/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.ExtraUtils2;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerSpecificRecipe
implements IRecipe {
    final IRecipe recipe;
    final CraftingAllowHandler craftingAllowHandler;

    public PlayerSpecificRecipe(IRecipe recipe, CraftingAllowHandler craftingAllowHandler) {
        this.recipe = recipe;
        this.craftingAllowHandler = craftingAllowHandler;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        return this.recipe.func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        if (this.isGoodForCrafting(inv)) {
            return this.recipe.func_77572_b(inv);
        }
        return null;
    }

    public int func_77570_a() {
        return this.recipe.func_77570_a();
    }

    public ItemStack func_77571_b() {
        return this.recipe.func_77571_b();
    }

    @Nonnull
    public ItemStack[] func_179532_b(@Nonnull InventoryCrafting inv) {
        return this.recipe.func_179532_b(inv);
    }

    public boolean isGoodForCrafting(InventoryCrafting inv) {
        PlayerList manager;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            EntityPlayer player = ExtraUtils2.proxy.getClientPlayer();
            return player != null && this.craftingAllowHandler.shouldAllowCraft(player);
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (manager = server.func_184103_al()) != null) {
            Container container = inv.field_70465_c;
            if (container == null) {
                return false;
            }
            EntityPlayerMP foundPlayer = null;
            for (EntityPlayerMP entityPlayerMP : manager.getPlayerList()) {
                if (entityPlayerMP.field_71070_bA != container || !container.func_75145_c((EntityPlayer)entityPlayerMP) || !container.func_75129_b((EntityPlayer)entityPlayerMP)) continue;
                if (foundPlayer != null) {
                    return false;
                }
                foundPlayer = entityPlayerMP;
            }
            if (foundPlayer != null) {
                this.craftingAllowHandler.onFoundPlayer(foundPlayer);
                return this.craftingAllowHandler.shouldAllowCraft((EntityPlayer)foundPlayer);
            }
        }
        return false;
    }

    static interface CraftingAllowHandler {
        public boolean shouldAllowCraft(EntityPlayer var1);

        public void onFoundPlayer(EntityPlayerMP var1);
    }
}

