/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting;

import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.RecipeBase;
import com.rwtema.extrautils2.crafting.XUShapedRecipe;
import com.rwtema.extrautils2.items.itemmatching.IMatcher;
import com.rwtema.extrautils2.items.itemmatching.Matchers;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;

public abstract class AdvShapelessRecipeBase
extends RecipeBase
implements IRecipe {
    protected LinkedHashMap<String, IMatcher> matchers = new LinkedHashMap();
    protected HashMap<String, Object> exampleStacks = new HashMap();
    private ItemStack output;

    protected AdvShapelessRecipeBase() {
        this(null);
    }

    protected AdvShapelessRecipeBase(ItemStack output) {
        this.output = output;
    }

    public int func_77570_a() {
        return this.matchers.size();
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World worldIn) {
        return this.assignValues(inv).size() == this.matchers.size();
    }

    @ItemStackNonNull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
        HashMap<String, ItemStack> map = this.assignValues(inv);
        return this.getResult(map);
    }

    @ItemStackNonNull
    public final ItemStack func_77571_b() {
        if (StackHelper.isNull(this.output)) {
            ItemStack result = this.initResult();
            Validate.notNull((Object)result);
            this.output = result;
        }
        return this.output;
    }

    protected ItemStack initResult() {
        HashMap<String, ItemStack> map = new HashMap<String, ItemStack>();
        for (String s : this.exampleStacks.keySet()) {
            Object o = this.exampleStacks.get(s);
            ItemStack stack = o instanceof Iterable ? (ItemStack)((Iterable)o).iterator().next() : (ItemStack)o;
            map.put(s, stack);
        }
        return this.getResult(map);
    }

    @ItemStackNonNull
    protected abstract ItemStack getResult(HashMap<String, ItemStack> var1);

    public String addMatcher(String key, ItemStack example) {
        return this.addMatcher(key, Matchers.createMatcher(example, true), example);
    }

    public String addMatcher(String key, IMatcher matcher, Object example) {
        this.matchers.put(key, matcher);
        this.exampleStacks.put(key, XUShapedRecipe.getRecipeObject(example));
        return key;
    }

    public HashMap<String, ItemStack> assignValues(InventoryCrafting inv) {
        HashMap<String, ItemStack> map = new HashMap<String, ItemStack>();
        block0: for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            for (Map.Entry<String, IMatcher> entry2 : this.matchers.entrySet()) {
                String key = entry2.getKey();
                if (map.containsKey(key) || !entry2.getValue().matchesItemStack(stack)) continue;
                map.put(key, stack);
                continue block0;
            }
        }
        return map;
    }
}

