/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.IMetaProperty;
import com.rwtema.extrautils2.backend.PropertyEnumSimple;
import com.rwtema.extrautils2.backend.XUBlockStateCreator;
import com.rwtema.extrautils2.backend.XUBlockStatic;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.XUBlockState;
import com.rwtema.extrautils2.blocks.BlockPassiveGenerator;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.tile.TileSynergyUnit;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockSynergy
extends XUBlockStatic {
    public static final IMetaProperty<SynergyType> TYPE = new IMetaProperty.WrapTile<SynergyType, TileSynergyUnit>(TileSynergyUnit.class, new PropertyEnumSimple<SynergyType>(SynergyType.class), SynergyType.BLANK){

        @Override
        public SynergyType getValue(TileSynergyUnit tile) {
            return (SynergyType)((Object)tile.synergy_type.value);
        }

        @Override
        public boolean isVisible() {
            return true;
        }

        @Override
        public boolean addLocalization() {
            return true;
        }
    };

    public static SynergyType getMeta(int meta) {
        return meta >= 0 && meta < SynergyType.values().length ? SynergyType.values()[meta] : SynergyType.BLANK;
    }

    @Override
    @Nonnull
    protected XUBlockStateCreator createBlockState() {
        return XUBlockStateCreator.builder(this).addMetaProperty(TYPE).build();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nonnull
    public TileEntity createTileEntity(@Nonnull World world, @Nonnull IBlockState state) {
        TileSynergyUnit synergyUnit = new TileSynergyUnit();
        synergyUnit.synergy_type.value = (Enum)((Object)state.func_177229_b(TYPE));
        return synergyUnit;
    }

    @Override
    public void getSubBlocksBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        for (int i = 0; i < SynergyType.values().length; ++i) {
            list.add(new ItemStack(itemIn, 1, i));
        }
    }

    @Override
    @Nonnull
    public IBlockState xuOnBlockPlacedBase(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)BlockSynergy.getMeta(meta)));
    }

    @Override
    public boolean getHasSubtypes() {
        return true;
    }

    @Override
    public BoxModel getModel(IBlockState state) {
        BoxModel model = new BoxModel();
        model.addBoxI(0, 0, 0, 16, 2, 16);
        for (int i = 0; i < 4; ++i) {
            model.addBoxI(1, 2, 1, 4, 14, 4).rotateY(i);
        }
        Box box = model.addBoxI(0, 14, 0, 16, 16, 16);
        model.setTextures("synergy/synergy_side", 0, "panel_base", 1, "panel_base");
        SynergyType value = (SynergyType)((Object)state.func_177229_b(TYPE));
        if (value != SynergyType.BLANK) {
            box.setTextureSides(1, "synergy/synergy_" + ((SynergyType)((Object)state.func_177229_b(TYPE))).name().toLowerCase(Locale.ENGLISH));
        }
        return model;
    }

    @Override
    public XUBlockState getStateFromItemStack(@Nullable ItemStack item) {
        if (StackHelper.isNull(item)) {
            return this.xuBlockState.defaultState;
        }
        return (XUBlockState)this.xuBlockState.defaultState.func_177226_a(TYPE, (Comparable)((Object)BlockSynergy.getMeta(item.func_77952_i())));
    }

    public static enum SynergyType {
        BLANK(null, null),
        WITHER(BlockPassiveGenerator.GeneratorType.DRAGON_EGG, BlockPassiveGenerator.GeneratorType.FIRE),
        NETHER(BlockPassiveGenerator.GeneratorType.DRAGON_EGG, BlockPassiveGenerator.GeneratorType.LAVA),
        VOID(BlockPassiveGenerator.GeneratorType.DRAGON_EGG, BlockPassiveGenerator.GeneratorType.LUNAR),
        TEMPLE(BlockPassiveGenerator.GeneratorType.DRAGON_EGG, BlockPassiveGenerator.GeneratorType.SOLAR),
        GUARDIAN(BlockPassiveGenerator.GeneratorType.DRAGON_EGG, BlockPassiveGenerator.GeneratorType.WATER),
        END(BlockPassiveGenerator.GeneratorType.DRAGON_EGG, BlockPassiveGenerator.GeneratorType.WIND),
        BRIMSTONE(BlockPassiveGenerator.GeneratorType.FIRE, BlockPassiveGenerator.GeneratorType.LAVA),
        BLOODMOON(BlockPassiveGenerator.GeneratorType.FIRE, BlockPassiveGenerator.GeneratorType.LUNAR),
        INCANDESCENCE(BlockPassiveGenerator.GeneratorType.FIRE, BlockPassiveGenerator.GeneratorType.SOLAR),
        STEAM(BlockPassiveGenerator.GeneratorType.FIRE, BlockPassiveGenerator.GeneratorType.WATER),
        FIRESTORM(BlockPassiveGenerator.GeneratorType.FIRE, BlockPassiveGenerator.GeneratorType.WIND),
        MOONQUAKE(BlockPassiveGenerator.GeneratorType.LAVA, BlockPassiveGenerator.GeneratorType.LUNAR),
        PLASMA(BlockPassiveGenerator.GeneratorType.LAVA, BlockPassiveGenerator.GeneratorType.SOLAR),
        COBBLESTONE(BlockPassiveGenerator.GeneratorType.LAVA, BlockPassiveGenerator.GeneratorType.WATER),
        METEOR(BlockPassiveGenerator.GeneratorType.LAVA, BlockPassiveGenerator.GeneratorType.WIND),
        ECLIPSE(BlockPassiveGenerator.GeneratorType.LUNAR, BlockPassiveGenerator.GeneratorType.SOLAR),
        LOWTIDE(BlockPassiveGenerator.GeneratorType.LUNAR, BlockPassiveGenerator.GeneratorType.WATER),
        AURORA(BlockPassiveGenerator.GeneratorType.LUNAR, BlockPassiveGenerator.GeneratorType.WIND),
        HIGHTIDE(BlockPassiveGenerator.GeneratorType.SOLAR, BlockPassiveGenerator.GeneratorType.WATER),
        SOLARFLARE(BlockPassiveGenerator.GeneratorType.SOLAR, BlockPassiveGenerator.GeneratorType.WIND),
        RAIN(BlockPassiveGenerator.GeneratorType.WATER, BlockPassiveGenerator.GeneratorType.WIND);

        public BlockPassiveGenerator.GeneratorType a;
        public BlockPassiveGenerator.GeneratorType b;
        public float boost = 0.05f;

        private SynergyType(BlockPassiveGenerator.GeneratorType a, BlockPassiveGenerator.GeneratorType b) {
            this.a = a;
            this.b = b;
        }
    }
}

