/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.blocks;

import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.BoxMimic;
import com.rwtema.extrautils2.backend.model.BoxModel;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.items.ItemIngredients;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.WorldHelper;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMoonStone
extends XUBlock {
    public static IBlockState mimicState = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE);

    public BlockMoonStone() {
        super(Material.field_151576_e);
    }

    @Override
    @Nonnull
    public BoxModel getWorldModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        return this.getModel();
    }

    @Override
    public void registerTextures() {
        Textures.register("moon_stone_cutout");
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getRenderModel(IBlockAccess world, BlockPos pos, @Nullable IBlockState state) {
        WorldClient theWorld;
        BoxModel model = BoxModel.newStandardBlock(false);
        model.add(new BoxMimic(world, pos, mimicState));
        WorldClient worldClient = theWorld = world instanceof WorldClient ? (WorldClient)world : Minecraft.func_71410_x().field_71441_e;
        if (theWorld != null && WorldHelper.isFullMoon((World)theWorld)) {
            Box box = model.addBox(-9.765625E-4f, -9.765625E-4f, -9.765625E-4f, 1.0009766f, 1.0009766f, 1.0009766f).setTexture("moon_stone_cutout");
            box.layer = BlockRenderLayer.TRANSLUCENT;
            int combinedLight = world.func_175626_b(pos, 0);
            int b = combinedLight >> 4 & 0xF;
            b = (int)((float)b * WorldHelper.getMoonBrightness((World)theWorld));
            int alpha = 255 - 2 * b * 12;
            box.color = ColorHelper.makeAlphaWhite(alpha);
        }
        return model;
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BoxModel getInventoryModel(@Nullable ItemStack item) {
        BoxModel boxes = BoxModel.newStandardBlock();
        boxes.sprite = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(mimicState);
        return boxes;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Blocks.field_150348_b.func_180660_a(mimicState, rand, fortune);
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return Blocks.field_150348_b.func_180651_a(mimicState);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    @Nonnull
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, @Nonnull IBlockState state, int fortune) {
        World world1;
        List drops = Blocks.field_150348_b.getDrops(world, pos, mimicState, fortune);
        if (world instanceof World && WorldHelper.isFullMoon(world1 = (World)world)) {
            drops.add(ItemIngredients.Type.MOON_STONE.newStack(1));
        }
        return drops;
    }

    public BoxModel getModel() {
        return BoxModel.newStandardBlock();
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, @Nonnull BlockRenderLayer layer) {
        return Blocks.field_150348_b.canRenderInLayer(mimicState, layer) || layer == BlockRenderLayer.TRANSLUCENT;
    }
}

