/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.model;

import com.google.common.collect.ImmutableList;
import com.rwtema.extrautils2.backend.model.Box;
import com.rwtema.extrautils2.backend.model.UV;
import com.rwtema.extrautils2.utils.helpers.QuadHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;

public class BoxSingleQuad
extends Box {
    private final UV[] vecs;
    public boolean addShading = true;
    boolean doubleSided = true;

    public BoxSingleQuad(Vec3d pos0, float u0, float v0, Vec3d pos1, float u1, float v1, Vec3d pos2, float u2, float v2, Vec3d pos3, float u3, float v3) {
        this(new UV(pos0, u0, v0), new UV(pos1, u1, v1), new UV(pos2, u2, v2), new UV(pos3, u3, v3));
    }

    public BoxSingleQuad(UV ... vecs) {
        super(BoxSingleQuad.getBB(vecs, 0), BoxSingleQuad.getBB(vecs, 1), BoxSingleQuad.getBB(vecs, 2), BoxSingleQuad.getBB(vecs, 3), BoxSingleQuad.getBB(vecs, 4), BoxSingleQuad.getBB(vecs, 5));
        this.vecs = vecs;
    }

    public static float getBB(UV[] vecs, int i) {
        float k = i >= 3 ? Float.MIN_VALUE : Float.MAX_VALUE;
        for (UV vec : vecs) {
            float t;
            switch (i) {
                case 0: 
                case 3: {
                    t = vec.x;
                    break;
                }
                case 1: 
                case 4: {
                    t = vec.y;
                    break;
                }
                case 2: 
                case 5: {
                    t = vec.z;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong Arg: " + i);
                }
            }
            k = i >= 3 ? Math.max(k, t) : Math.min(k, t);
        }
        return k;
    }

    @Override
    public BoxSingleQuad copy() {
        UV[] v = new UV[this.vecs.length];
        for (int i = 0; i < this.vecs.length; ++i) {
            v[i] = this.vecs[i].copy();
        }
        BoxSingleQuad box = new BoxSingleQuad(v);
        box.doubleSided = this.doubleSided;
        box.addShading = this.addShading;
        return box;
    }

    @Override
    public Box rotateY(int numRotations) {
        if (numRotations == 0) {
            return this;
        }
        if (numRotations < 0) {
            numRotations += 4;
        }
        if ((numRotations &= 3) == 0) {
            return this;
        }
        this.clearCache();
        for (int i = 0; i < numRotations; ++i) {
            BoxSingleQuad prev = this.copy();
            for (int i1 = 0; i1 < this.vecs.length; ++i1) {
                UV uv = this.vecs[i1];
                UV pv = prev.vecs[i1];
                uv.x = pv.z;
                uv.z = 1.0f - pv.x;
            }
        }
        this.setBounds(BoxSingleQuad.getBB(this.vecs, 0), BoxSingleQuad.getBB(this.vecs, 1), BoxSingleQuad.getBB(this.vecs, 2), BoxSingleQuad.getBB(this.vecs, 3), BoxSingleQuad.getBB(this.vecs, 4), BoxSingleQuad.getBB(this.vecs, 5));
        return this;
    }

    @Override
    public Box rotateToSide(EnumFacing dir) {
        if (dir == EnumFacing.DOWN) {
            return this;
        }
        BoxSingleQuad prev = this.copy();
        this.clearCache();
        block7: for (int i = 0; i < this.vecs.length; ++i) {
            UV vec = this.vecs[i];
            UV pv = prev.vecs[i];
            switch (dir) {
                case UP: {
                    vec.y = 1.0f - pv.y;
                    vec.z = 1.0f - pv.z;
                    continue block7;
                }
                case NORTH: {
                    vec.x = 1.0f - pv.x;
                    vec.y = pv.z;
                    vec.z = pv.y;
                    continue block7;
                }
                case SOUTH: {
                    vec.y = pv.z;
                    vec.z = 1.0f - pv.y;
                    continue block7;
                }
                case WEST: {
                    vec.x = pv.y;
                    vec.y = pv.z;
                    vec.z = pv.x;
                    continue block7;
                }
                case EAST: {
                    vec.x = 1.0f - pv.y;
                    vec.y = pv.z;
                    vec.z = 1.0f - pv.x;
                    continue block7;
                }
            }
        }
        this.setBounds(BoxSingleQuad.getBB(this.vecs, 0), BoxSingleQuad.getBB(this.vecs, 1), BoxSingleQuad.getBB(this.vecs, 2), BoxSingleQuad.getBB(this.vecs, 3), BoxSingleQuad.getBB(this.vecs, 4), BoxSingleQuad.getBB(this.vecs, 5));
        return this;
    }

    @Override
    public void clearCache() {
    }

    @Override
    public List<BakedQuad> makeQuads(@Nullable EnumFacing side) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (this.doubleSided) {
            UV[] v2 = new UV[this.vecs.length];
            for (int i = 0; i < v2.length; ++i) {
                v2[i] = this.vecs[this.vecs.length - 1 - i];
            }
            return ImmutableList.of((Object)QuadHelper.createBakedQuad(this.vecs, this.texture, this.addShading, this.tint), (Object)QuadHelper.createBakedQuad(v2, this.texture, this.addShading, this.tint));
        }
        return ImmutableList.of((Object)QuadHelper.createBakedQuad(this.vecs, this.texture, this.addShading, this.tint));
    }

    public Box setDoubleSided(boolean doubleSided) {
        this.doubleSided = doubleSided;
        return this;
    }
}

