/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.asm;

import com.rwtema.extrautils2.asm.ClassTransformerHandler;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ItemStackChecker
implements IClassTransformer {
    TreeSet<String> set = new TreeSet();

    public byte[] transform(String s, String s1, byte[] bytes) {
        if (!s1.startsWith("com.rwtema.extrautils2")) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 8);
        Type type = Type.getType((String)"Lnet/minecraft/item/ItemStack;");
        boolean shouldReport = false;
        HashSet<LocalVariableNode> itemStackVariables = new HashSet<LocalVariableNode>();
        HashSet<LabelNode> visitedLabels = new HashSet<LabelNode>();
        for (MethodNode method : classNode.methods) {
            Type returnType = Type.getReturnType((String)method.desc);
            visitedLabels.clear();
            itemStackVariables.clear();
            List localVariables = method.localVariables;
            if (localVariables != null) {
                for (LocalVariableNode localVariable : localVariables) {
                    if (!type.equals((Object)Type.getType((String)localVariable.desc))) continue;
                    itemStackVariables.add(localVariable);
                }
            }
            boolean checkReturn = returnType.equals((Object)type);
            boolean foundAconstNull = false;
            int lineNumber = -1;
            for (AbstractInsnNode insnNode : method.instructions) {
                int opcode = insnNode.getOpcode();
                if (opcode == 1) {
                    foundAconstNull = true;
                    continue;
                }
                if (opcode == -1) {
                    if (insnNode instanceof LabelNode) {
                        visitedLabels.add((LabelNode)insnNode);
                    }
                    if (!(insnNode instanceof LineNumberNode)) continue;
                    lineNumber = ((LineNumberNode)insnNode).line;
                    continue;
                }
                if (opcode == 58 && foundAconstNull) {
                    VarInsnNode varInsnNode = (VarInsnNode)insnNode;
                    for (LocalVariableNode itemStackVariable : itemStackVariables) {
                        if (itemStackVariable.index != varInsnNode.var || !visitedLabels.contains(itemStackVariable.start) || visitedLabels.contains(itemStackVariable.end)) continue;
                        this.report(classNode, method, lineNumber);
                        shouldReport = true;
                        break;
                    }
                    foundAconstNull = false;
                    continue;
                }
                if (checkReturn && opcode == 176 && foundAconstNull) {
                    this.report(classNode, method, lineNumber);
                    shouldReport = true;
                    foundAconstNull = false;
                    continue;
                }
                if ((opcode == 181 || opcode == 179) && foundAconstNull) {
                    FieldInsnNode fieldInsnNode = (FieldInsnNode)insnNode;
                    if (type.equals((Object)Type.getType((String)fieldInsnNode.desc))) {
                        this.report(classNode, method, lineNumber);
                        shouldReport = true;
                    }
                    foundAconstNull = false;
                    continue;
                }
                foundAconstNull = false;
            }
        }
        if (shouldReport) {
            StringBuilder builder = new StringBuilder("Found null ItemStack assignments:");
            for (String s2 : this.set) {
                builder.append('\n').append('\t').append(s2);
            }
            ClassTransformerHandler.logger.info(builder.toString());
        }
        return bytes;
    }

    private void report(ClassNode classNode, MethodNode method, int lineNumber) {
        String s = new StackTraceElement(classNode.name.replace('/', '.'), method.name, classNode.sourceFile, lineNumber).toString();
        this.set.add(s);
    }
}

