/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.world;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.apiimpl.PlantRegistry;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.entity.villager.EntityVillagerFarmer;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import com.infinityraider.agricraft.tiles.analyzer.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.utility.WorldGenerationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class StructureGreenhouse
extends StructureVillagePieces.House1 {
    private static final int xSize = 17;
    private static final int ySize = 10;
    private static final int zSize = 11;
    private int averageGroundLevel = -1;

    public StructureGreenhouse() {
    }

    public StructureGreenhouse(StructureVillagePieces.Start villagePiece, int nr, Random rand, StructureBoundingBox structureBoundingBox, EnumFacing coordBaseMode) {
        this.func_186164_a(coordBaseMode);
        this.field_74887_e = structureBoundingBox;
    }

    public static StructureGreenhouse buildComponent(StructureVillagePieces.Start villagePiece, List<StructureComponent> pieces, Random random, int p1, int p2, int p3, EnumFacing facing, int p5) {
        StructureBoundingBox boundingBox = StructureBoundingBox.func_175897_a((int)p1, (int)p2, (int)p3, (int)0, (int)0, (int)0, (int)17, (int)10, (int)11, (EnumFacing)facing);
        return StructureGreenhouse.func_74895_a((StructureBoundingBox)boundingBox) && StructureComponent.func_74883_a(pieces, (StructureBoundingBox)boundingBox) == null ? new StructureGreenhouse(villagePiece, p5, random, boundingBox, facing) : null;
    }

    public boolean func_74875_a(World world, Random rand, StructureBoundingBox boundingBox) {
        int z;
        int x;
        if (this.averageGroundLevel < 0) {
            this.averageGroundLevel = this.func_74889_b(world, boundingBox);
            if (this.averageGroundLevel < 0) {
                return true;
            }
            this.field_74887_e.func_78886_a(0, this.averageGroundLevel - this.field_74887_e.field_78894_e + 7, 0);
        }
        this.func_175804_a(world, boundingBox, 0, 0, 0, 16, 0, 10, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 0, 1, 0, 16, 1, 0, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 0, 1, 0, 0, 1, 10, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 0, 1, 10, 16, 1, 10, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 16, 1, 0, 16, 1, 10, Blocks.field_150351_n.func_176223_P(), Blocks.field_150351_n.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 1, 1, 1, 1, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 1, 6, 1, 1, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 1, 1, 15, 1, 4, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 1, 6, 15, 1, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), 2, 1, 1, boundingBox);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), 8, 1, 1, boundingBox);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), 14, 1, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), 2, 1, 9, boundingBox);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), 8, 1, 9, boundingBox);
        this.func_175811_a(world, Blocks.field_150347_e.func_176223_P(), 14, 1, 9, boundingBox);
        this.func_175811_a(world, Blocks.field_150334_T.func_176223_P(), 1, 1, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_150334_T.func_176223_P(), 15, 1, 5, boundingBox);
        this.func_175804_a(world, boundingBox, 2, 1, 2, 2, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 8, 1, 2, 8, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 14, 1, 2, 14, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 1, 2, 14, 1, 2, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 1, 8, 14, 1, 8, Blocks.field_150334_T.func_176223_P(), Blocks.field_150334_T.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 3, 1, 1, 7, 1, 1, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 1, 1, 10, 1, 1, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 3, 1, 9, 7, 1, 9, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 1, 9, 13, 1, 9, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
        this.func_175811_a(world, Blocks.field_150355_j.func_176223_P(), 13, 1, 6, boundingBox);
        this.func_175804_a(world, boundingBox, 3, 1, 3, 7, 1, 7, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), false);
        this.func_175804_a(world, boundingBox, 9, 1, 3, 13, 1, 7, Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), Blocks.field_150458_ak.func_176223_P().func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), false);
        this.func_175804_a(world, boundingBox, 1, 2, 1, 1, 6, 1, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 8, 2, 1, 8, 6, 1, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 2, 1, 15, 6, 1, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 2, 4, 1, 5, 4, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 2, 4, 15, 5, 4, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 2, 6, 1, 5, 6, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 2, 6, 15, 5, 6, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 2, 9, 1, 6, 9, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 8, 2, 9, 8, 6, 9, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 2, 9, 15, 6, 9, Blocks.field_150364_r.func_176223_P(), Blocks.field_150364_r.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 6, 1, 7, 6, 1, Blocks.field_150364_r.func_176203_a(4), Blocks.field_150364_r.func_176203_a(4), false);
        this.func_175804_a(world, boundingBox, 9, 6, 1, 14, 6, 1, Blocks.field_150364_r.func_176203_a(4), Blocks.field_150364_r.func_176203_a(4), false);
        this.func_175804_a(world, boundingBox, 2, 6, 9, 7, 6, 9, Blocks.field_150364_r.func_176203_a(4), Blocks.field_150364_r.func_176203_a(4), false);
        this.func_175804_a(world, boundingBox, 9, 6, 9, 14, 6, 9, Blocks.field_150364_r.func_176203_a(4), Blocks.field_150364_r.func_176203_a(4), false);
        this.func_175804_a(world, boundingBox, 1, 6, 2, 1, 6, 8, Blocks.field_150364_r.func_176203_a(8), Blocks.field_150364_r.func_176203_a(8), false);
        this.func_175804_a(world, boundingBox, 8, 6, 2, 8, 6, 8, Blocks.field_150364_r.func_176203_a(8), Blocks.field_150364_r.func_176203_a(8), false);
        this.func_175804_a(world, boundingBox, 15, 6, 2, 15, 6, 8, Blocks.field_150364_r.func_176203_a(8), Blocks.field_150364_r.func_176203_a(8), false);
        this.func_175811_a(world, Blocks.field_150364_r.func_176203_a(8), 1, 4, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_150364_r.func_176203_a(8), 15, 4, 5, boundingBox);
        this.func_175804_a(world, boundingBox, 2, 2, 1, 7, 2, 1, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 2, 1, 14, 2, 1, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 2, 2, 1, 2, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 2, 7, 1, 2, 8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 2, 2, 15, 2, 3, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 2, 7, 15, 2, 8, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 2, 9, 7, 2, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 2, 9, 14, 2, 9, Blocks.field_150347_e.func_176223_P(), Blocks.field_150347_e.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 3, 2, 1, 5, 3, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 3, 7, 1, 5, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 3, 2, 15, 5, 3, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 15, 3, 7, 15, 5, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 3, 1, 7, 5, 1, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 3, 1, 14, 5, 1, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 3, 9, 7, 5, 9, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 3, 9, 14, 5, 9, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 6, 2, 7, 6, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 9, 6, 2, 14, 6, 8, Blocks.field_150359_w.func_176223_P(), Blocks.field_150359_w.func_176223_P(), false);
        this.func_175811_a(world, Blocks.field_150359_w.func_176223_P(), 1, 5, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_150359_w.func_176223_P(), 15, 5, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_180413_ao.func_176203_a(0), 1, 2, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_180413_ao.func_176203_a(8), 1, 3, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_180413_ao.func_176203_a(2), 15, 2, 5, boundingBox);
        this.func_175811_a(world, Blocks.field_180413_ao.func_176203_a(8), 15, 3, 5, boundingBox);
        this.func_175804_a(world, boundingBox, 0, 2, 0, 0, 9, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 16, 2, 0, 16, 9, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 0, 2, 0, 16, 9, 0, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 0, 2, 10, 16, 9, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 2, 2, 2, 14, 5, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, boundingBox, 1, 7, 1, 14, 9, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 0, 4, 1, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 0, 4, 4, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 0, 4, 6, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 0, 4, 9, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 14, 4, 4, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 14, 4, 6, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 1, 4, 0, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 8, 4, 0, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 15, 4, 0, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 8, 4, 8, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 16, 4, 1, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 16, 4, 4, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 16, 4, 6, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 16, 4, 9, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 2, 4, 4, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 2, 4, 6, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 1, 4, 10, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 8, 4, 10, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 15, 4, 10, boundingBox);
        this.func_175811_a(world, Blocks.field_150478_aa.func_176223_P(), 8, 4, 2, boundingBox);
        ArrayList<IAgriPlant> plants = new ArrayList<IAgriPlant>(PlantRegistry.getInstance().getPlants());
        plants.removeIf(p -> p.getTier() > AgriCraftConfig.greenHouseMaxTier);
        for (x = 3; x <= 7; ++x) {
            for (z = 3; z <= 7; ++z) {
                this.generateStructureCrop(world, boundingBox, x, 2, z, z % 2 == 0 && x % 2 == 0 || x == 5 && z == 5, plants);
            }
        }
        for (x = 9; x <= 13; ++x) {
            for (z = 3; z <= 7; ++z) {
                this.generateStructureCrop(world, boundingBox, x, 2, z, z % 2 == 0 && x % 2 == 0 || x == 11 && z == 5, plants);
            }
        }
        this.func_74893_a(world, boundingBox, 3, 1, 3, 1);
        return true;
    }

    protected boolean generateStructureCrop(World world, StructureBoundingBox boundingBox, int x, int y, int z, boolean crosscrop, List<IAgriPlant> plants) {
        int xCoord = this.func_74865_a(x, z);
        int yCoord = this.func_74862_a(y);
        int zCoord = this.func_74873_b(x, z);
        AgriCore.getLogger("AgriCraft").debug("Placing crop at (" + xCoord + "," + yCoord + "," + zCoord + ")", new Object[0]);
        if (boundingBox.func_175898_b(new Vec3i(xCoord, yCoord, zCoord))) {
            BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
            TileEntityCrop crop = (TileEntityCrop)world.func_175625_s(pos);
            if (crop != null) {
                if (crosscrop) {
                    crop.setCrossCrop(true);
                } else if (plants.size() > 0) {
                    crop.setSeed(WorldGenerationHelper.getRandomSeed(world.field_73012_v, false, plants));
                } else {
                    AgriCore.getLogger("AgriCraft").debug("no registered plants were find, skipping plant generation", new Object[0]);
                }
            }
            return true;
        }
        return false;
    }

    protected boolean generateStructureSeedAnalyzer(World world, StructureBoundingBox boundingBox, int x, int y, int z, EnumFacing direction) {
        int zCoord;
        int yCoord;
        int xCoord = this.func_74865_a(x, z);
        if (boundingBox.func_175898_b(new Vec3i(xCoord, yCoord = this.func_74862_a(y), zCoord = this.func_74873_b(x, z)))) {
            BlockPos pos = new BlockPos(xCoord, yCoord, zCoord);
            world.func_180501_a(pos, AgriBlocks.getInstance().SEED_ANALYZER.func_176223_P(), 2);
            TileEntitySeedAnalyzer analyzer = (TileEntitySeedAnalyzer)world.func_175625_s(pos);
            if (analyzer != null && direction != null) {
                analyzer.setOrientation(direction);
            }
            return true;
        }
        return false;
    }

    protected void func_74893_a(World world, StructureBoundingBox boundingBox, int x, int y, int z, int limit) {
        if (AgriCraftConfig.villagerEnabled) {
            int nrVillagersSpawned = this.getNumberOfSpawnedVillagers(world);
            if (nrVillagersSpawned < limit) {
                int l1;
                int k1;
                int j1;
                for (int i1 = nrVillagersSpawned; i1 < limit && boundingBox.func_175898_b(new Vec3i(j1 = this.func_74865_a(x + i1, z), k1 = this.func_74862_a(y), l1 = this.func_74873_b(x + i1, z))); ++i1) {
                    ++nrVillagersSpawned;
                    EntityVillagerFarmer villager = new EntityVillagerFarmer(world);
                    villager.func_70012_b((double)j1 + 0.5, (double)k1 + 1.0, (double)l1 + 0.5, 0.0f, 0.0f);
                    world.func_72838_d((Entity)villager);
                }
            }
            this.setNumberOfSpawnedVillagers(world, nrVillagersSpawned);
        }
    }

    private int getNumberOfSpawnedVillagers(World world) {
        NBTTagCompound villageTag = new NBTTagCompound();
        this.func_143009_a(world, villageTag);
        return villageTag.func_74762_e("VCount");
    }

    private void setNumberOfSpawnedVillagers(World world, int nr) {
        NBTTagCompound villageTag = new NBTTagCompound();
        this.func_143009_a(world, villageTag);
        villageTag.func_74768_a("VCount", nr);
        this.func_143012_a(villageTag);
    }
}

