/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class WeightedRandom<T> {
    private int totalWeight = 0;
    private final HashMap<T, Integer> entries = new HashMap();

    public void addEntry(T entry, int weight) {
        this.entries.put(entry, weight);
        this.totalWeight += weight;
    }

    public void removeEntry(T entry) {
        Integer e = this.entries.remove(entry);
        if (e != null) {
            this.totalWeight -= e.intValue();
        }
    }

    public T getRandomEntry(Random rand) {
        double threshold = rand.nextDouble() * (double)this.totalWeight;
        for (Map.Entry<T, Integer> mapEntry : this.entries.entrySet()) {
            if (!((threshold -= (double)mapEntry.getValue().intValue()) <= 0.0)) continue;
            return mapEntry.getKey();
        }
        return null;
    }

    public int getWeight(T entry) {
        return this.entries.getOrDefault(entry, 0);
    }
}

