/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.util.TypeHelper;
import com.infinityraider.agricraft.utility.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class StackHelper {
    public static boolean isValid(ItemStack stack) {
        return stack != null && stack.func_77973_b() != null;
    }

    public static boolean isValid(ItemStack ... stacks) {
        for (ItemStack stack : stacks) {
            if (StackHelper.isValid(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean isValid(ItemStack stack, Class ... itemClasses) {
        return StackHelper.isValid(stack) && TypeHelper.isAllTypes(stack.func_77973_b(), itemClasses);
    }

    public static boolean areEqual(ItemStack a, ItemStack b) {
        return StackHelper.isValid(a, b) && a.func_77973_b() == b.func_77973_b() && (!a.func_77981_g() || a.func_77952_i() == b.func_77952_i()) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    public static boolean hasTag(ItemStack stack) {
        return StackHelper.isValid(stack) && stack.func_77942_o();
    }

    public static boolean hasKey(ItemStack stack, String ... keys) {
        return StackHelper.hasTag(stack) && NBTHelper.hasKey(stack.func_77978_p(), keys);
    }

    public static NBTTagCompound getTag(ItemStack stack) {
        if (StackHelper.hasTag(stack)) {
            return stack.func_77978_p();
        }
        NBTTagCompound tag = new NBTTagCompound();
        stack.func_77982_d(tag);
        return tag;
    }

    public static List<ItemStack> fitToMaxSize(ItemStack stack) {
        ItemStack newStack;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        int max = stack.func_77976_d();
        for (int total = stack.field_77994_a; total > 0; total -= newStack.field_77994_a) {
            newStack = stack.func_77946_l();
            newStack.field_77994_a = Math.min(total, max);
            items.add(newStack);
        }
        return items;
    }
}

