/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.TypeHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModelErrorSuppressor {
    private static final List<String> IGNORES = TypeHelper.asList("agricraft", "agricraftitem");
    @AgriConfigurable(key="Suppress Model Errors", category=AgriConfigCategory.DEBUG, comment="Set to true to prevent any annoying AgriCraft model loading errors from spamming the log.")
    private static boolean supressErrors = true;

    @SubscribeEvent
    public void onModelBakePost(ModelBakeEvent event) {
        if (supressErrors) {
            Map modelErrors = (Map)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"loadingExceptions"});
            Set missingVariants = (Set)ReflectionHelper.getPrivateValue(ModelLoader.class, (Object)event.getModelLoader(), (String[])new String[]{"missingVariants"});
            List<ResourceLocation> errored = modelErrors.keySet().stream().filter(r -> IGNORES.contains(r.func_110624_b())).collect(Collectors.toList());
            List<ResourceLocation> missing = missingVariants.stream().filter(r -> IGNORES.contains(r.func_110624_b())).collect(Collectors.toList());
            errored.forEach(modelErrors::remove);
            missing.forEach(missingVariants::remove);
            AgriCore.getLogger("AgriCraft").info("Suppressed {0} Model Loading Errors!", errored.size());
            AgriCore.getLogger("AgriCraft").info("Suppressed {0} Missing Model Variants!", missing.size());
        }
    }

    static {
        AgriCore.getConfig().addConfigurable(ModelErrorSuppressor.class);
    }
}

