/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.core.AgriCore;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class IconHelper {
    public static final String EXPANSION_POINT = ":";
    public static final String EXPANSION_BLOCK = ":blocks/";
    public static final String EXPANSION_ITEM = ":items/";
    private static final Map<String, Deque<String>> findCache = new HashMap<String, Deque<String>>();
    private static final AtomicInteger failCounter = new AtomicInteger();

    private IconHelper() {
    }

    public static TextureAtlasSprite getDefaultIcon() {
        return DefaultIcon.instance;
    }

    public static TextureAtlasSprite getIcon(String resourceLocation) {
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(resourceLocation);
        if (!sprite.func_94215_i().equals("missingno")) {
            return sprite;
        }
        int fail = failCounter.addAndGet(1);
        return IconHelper.getDefaultIcon();
    }

    private static TextureAtlasSprite getIcon(String path, String expansion) {
        return IconHelper.getIcon(path, expansion, "");
    }

    private static TextureAtlasSprite getIcon(String path, String expansion, String postfix) {
        return IconHelper.getIcon(path.replaceFirst(EXPANSION_POINT, expansion).concat(postfix));
    }

    public static TextureAtlasSprite getIcon(Block block) {
        return block == null ? IconHelper.getDefaultIcon() : IconHelper.getIcon(block.getRegistryName().toString(), EXPANSION_BLOCK);
    }

    public static TextureAtlasSprite getIcon(Item item) {
        return item == null ? IconHelper.getDefaultIcon() : IconHelper.getIcon(item.getRegistryName().toString(), EXPANSION_ITEM);
    }

    public static TextureAtlasSprite getParticleIcon(ItemStack stack) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack).func_177554_e();
    }

    public static TextureAtlasSprite getParticleIcon(Item item, int meta) {
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(item, meta);
    }

    public static TextureAtlasSprite registerIcon(String texturePath) {
        try {
            return Minecraft.func_71410_x().func_147117_R().func_174942_a(new ResourceLocation(texturePath));
        }
        catch (Exception e) {
            AgriCore.getLogger("AgriCraft").debug(e.getLocalizedMessage(), new Object[0]);
            return IconHelper.getDefaultIcon();
        }
    }

    public static Deque<String> findMatches(String name) {
        if (findCache.containsKey(name = name.toLowerCase())) {
            return findCache.get(name);
        }
        ArrayDeque<String> matches = new ArrayDeque<String>();
        try {
            Field f = TextureMap.class.getDeclaredField("mapRegisteredSprites");
            f.setAccessible(true);
            Map textureMap = (Map)f.get(Minecraft.func_71410_x().func_147117_R());
            for (String e : textureMap.keySet()) {
                if (!e.contains(name)) continue;
                matches.add(e);
            }
            if (!findCache.isEmpty()) {
                findCache.put(name, matches);
            } else {
                matches.add("missingno");
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            AgriCore.getLogger("AgriCraft").debug("Something strange is going on with the Minecraft TextureMap!", new Object[0]);
        }
        catch (SecurityException e) {
            AgriCore.getLogger("AgriCraft").debug("Locked out of TextureMap...", new Object[0]);
        }
        return matches;
    }

    private static class DefaultIcon
    extends TextureAtlasSprite {
        public static final TextureAtlasSprite instance = new DefaultIcon("missingno");

        private DefaultIcon(String location) {
            super(location);
            this.field_130223_c = 16;
            this.field_130224_d = 16;
            this.field_110976_a = new ArrayList(1);
            this.field_110976_a.add(new int[][]{TextureUtil.field_110999_b});
        }
    }
}

