/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import com.agricraft.agricore.core.AgriCore;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.utility.NBTHelper;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class CustomWoodType {
    @Nonnull
    public static final Block DEFAULT_MATERIAL = Blocks.field_150344_f;
    public static final int DEFAULT_META = 0;
    private static Map<IBlockState, CustomWoodType> woodTypes = new IdentityHashMap<IBlockState, CustomWoodType>();
    private final Block block;
    private final int meta;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite texture;

    public static List<CustomWoodType> getAllTypes() {
        return ImmutableList.copyOf(woodTypes.values());
    }

    public static CustomWoodType getFromBlockAndMeta(Block block, int meta) {
        return woodTypes.containsKey(block.func_176203_a(meta)) ? woodTypes.get(block.func_176203_a(meta)) : CustomWoodType.getDefault();
    }

    public static CustomWoodType getDefault() {
        return woodTypes.get(DEFAULT_MATERIAL.func_176203_a(0));
    }

    private CustomWoodType(Block block, int meta) {
        this.block = block;
        this.meta = meta;
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getState() {
        return this.getBlock().func_176203_a(this.getMeta());
    }

    public ItemStack getStack() {
        return new ItemStack(this.getBlock(), 1, this.getMeta());
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getIcon() {
        if (this.texture == null) {
            try {
                IBlockState state = this.block.func_176203_a(this.meta);
                this.texture = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
            }
            catch (Exception e) {
                AgriCore.getLogger("AgriCraft").debug("Unable to load texture for custom wood block {0}!", this.block.func_149732_F());
                AgriCore.getLogger("AgriCraft").trace(e);
                this.texture = Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }
        }
        return this.texture;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("agri_material", this.getBlock().getRegistryName().toString());
        tag.func_74768_a("agri_material_meta", this.getMeta());
        return tag;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CustomWoodType) {
            CustomWoodType other = (CustomWoodType)obj;
            return other.getBlock() == this.getBlock() && other.getMeta() == this.getMeta();
        }
        return false;
    }

    public static CustomWoodType readFromNBT(NBTTagCompound tag) {
        if (!NBTHelper.hasKey(tag, "agri_material_meta", "agri_material")) {
            return CustomWoodType.getDefault();
        }
        return CustomWoodType.getFromNameAndMeta(tag.func_74779_i("agri_material"), tag.func_74762_e("agri_material_meta"));
    }

    public static CustomWoodType getFromNameAndMeta(String name, int meta) {
        Block block = Block.func_149684_b((String)name);
        if (block == Blocks.field_150350_a) {
            AgriCore.getLogger("AgriCraft").debug("TECW: Material Defaulted!", new Object[0]);
            return CustomWoodType.getDefault();
        }
        return CustomWoodType.getFromBlockAndMeta(block, meta);
    }

    public static void init() {
        CustomWoodType.init(block -> IntStream.range(0, 16));
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        CustomWoodType.init(block -> {
            ArrayList subItems = new ArrayList();
            block.func_150895_a((Item)block, block.func_77640_w(), subItems);
            return subItems.stream().mapToInt(ItemStack::func_77952_i);
        });
    }

    private static void init(Function<ItemBlock, IntStream> getItemDamages) {
        if (!woodTypes.isEmpty()) {
            return;
        }
        OreDictionary.getOres((String)"plankWood").stream().filter(plank -> plank.func_77973_b() instanceof ItemBlock).flatMap(plank -> {
            ItemBlock block = (ItemBlock)plank.func_77973_b();
            if (plank.func_77952_i() == Short.MAX_VALUE) {
                return ((IntStream)getItemDamages.apply(block)).mapToObj(meta -> new CustomWoodType(block.field_150939_a, meta));
            }
            return Stream.of(new CustomWoodType(block.field_150939_a, plank.func_77952_i()));
        }).forEach(type -> woodTypes.put(type.getState(), (CustomWoodType)type));
    }
}

