/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.utility;

import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class BlockRange
implements Iterable<BlockPos> {
    private final BlockPos min;
    private final BlockPos max;

    public BlockRange(BlockRange range, BlockPos pos) {
        this(range.getMin().func_177971_a((Vec3i)pos), range.getMax().func_177971_a((Vec3i)pos));
    }

    public BlockRange(BlockPos center, int radius) {
        this(center.func_177958_n(), center.func_177956_o(), center.func_177952_p(), radius);
    }

    public BlockRange(BlockPos min, BlockPos max) {
        this(min.func_177958_n(), min.func_177956_o(), min.func_177952_p(), max.func_177958_n(), max.func_177956_o(), max.func_177952_p());
    }

    public BlockRange(int x, int y, int z, int radius) {
        this(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius);
    }

    public BlockRange(int x1, int y1, int z1, int x2, int y2, int z2) {
        int temp;
        if (x1 < x2) {
            temp = y1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        if (z1 < z2) {
            temp = z1;
            z1 = z2;
            z2 = temp;
        }
        this.min = new BlockPos(x1, y1, z1).func_185334_h();
        this.max = new BlockPos(x2, y2, z2).func_185334_h();
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getMax() {
        return this.max;
    }

    public int getVolume() {
        return (this.max.func_177958_n() - this.min.func_177958_n() + 1) * (this.max.func_177956_o() - this.min.func_177956_o() + 1) * (this.max.func_177952_p() - this.min.func_177952_p() + 1);
    }

    public boolean contains(BlockPos pos) {
        return pos.func_177958_n() >= this.min.func_177958_n() && pos.func_177956_o() >= this.min.func_177956_o() && pos.func_177952_p() >= this.min.func_177952_p() && pos.func_177958_n() <= this.max.func_177958_n() && pos.func_177956_o() <= this.max.func_177956_o() && pos.func_177952_p() <= this.max.func_177952_p();
    }

    public boolean intersects(BlockRange range) {
        return this.min.func_177958_n() < range.max.func_177958_n() && this.max.func_177958_n() > range.min.func_177958_n() && this.min.func_177956_o() < range.max.func_177956_o() && this.max.func_177956_o() > range.min.func_177956_o() && this.min.func_177952_p() < range.max.func_177952_p() && this.max.func_177952_p() > range.min.func_177952_p();
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new BlockRangeIterator(this);
    }

    public Stream<BlockPos> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public class BlockRangeIterator
    implements Iterator<BlockPos> {
        public final BlockPos pos;
        private final BlockRange range;

        public BlockRangeIterator(BlockRange range) {
            this.range = range;
            this.pos = range.getMin();
        }

        @Override
        public boolean hasNext() {
            return this.pos.func_177958_n() <= this.range.getMax().func_177958_n() || this.pos.func_177956_o() <= this.range.getMax().func_177956_o() || this.pos.func_177952_p() <= this.range.getMax().func_177952_p();
        }

        @Override
        public BlockPos next() {
            this.pos.func_177982_a(1, 0, 0);
            if (this.pos.func_177958_n() > this.range.getMax().func_177958_n()) {
                this.pos.func_177982_a(-1, 1, 0);
                if (this.pos.func_177956_o() > this.range.getMax().func_177956_o()) {
                    this.pos.func_177982_a(0, -1, 1);
                    if (this.pos.func_177952_p() > this.range.getMax().func_177952_p()) {
                        throw new IndexOutOfBoundsException();
                    }
                }
            }
            return this.pos.func_185334_h();
        }
    }
}

