/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.storage;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.network.MessageTileEntitySeedStorage;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageControllable;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageController;
import com.infinityraider.agricraft.tiles.storage.SeedStorageSlot;
import com.infinityraider.agricraft.utility.NBTHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySeedStorage
extends TileEntityCustomWood
implements ISeedStorageControllable,
IDebuggable,
ISidedInventory {
    private AgriSeed lockedSeed;
    private Map<Integer, SeedStorageSlot> slots = new HashMap<Integer, SeedStorageSlot>();
    private ArrayList<SeedStorageSlot> slotsList = new ArrayList();
    private ISeedStorageController controller;

    @Override
    protected void writeNBT(NBTTagCompound tag) {
        if (this.lockedSeed != null) {
            tag.func_74782_a("agri_seed", (NBTBase)this.lockedSeed.toStack().func_77955_b(new NBTTagCompound()));
            if (this.slots != null) {
                NBTTagList tagList = new NBTTagList();
                for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                    if (entry == null || entry.getValue() == null) continue;
                    NBTTagCompound slotTag = new NBTTagCompound();
                    entry.getValue().writeToNbt(slotTag);
                    tagList.func_74742_a((NBTBase)slotTag);
                }
                tag.func_74782_a("agri_inventory", (NBTBase)tagList);
            }
        }
        if (this.hasController()) {
            NBTHelper.addCoordsToNBT(this.controller.getCoordinates(), tag);
        }
    }

    @Override
    protected void readNBT(NBTTagCompound tag) {
        int[] coords;
        this.slots = new HashMap<Integer, SeedStorageSlot>();
        this.slotsList = new ArrayList();
        if (tag.func_74764_b("agri_seed")) {
            ItemStack seedStack = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("agri_seed"));
            this.lockedSeed = SeedRegistry.getInstance().valueOf(seedStack).orElse(null);
            if (tag.func_74764_b("agri_inventory")) {
                NBTTagList tagList = tag.func_150295_c("agri_inventory", 10);
                int invId = this.getControllableID();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    SeedStorageSlot slot = SeedStorageSlot.readFromNbt(tagList.func_150305_b(i), invId).orElse(null);
                    if (slot == null) continue;
                    this.slots.put(slot.getId(), slot);
                    this.slotsList.add(slot);
                }
            }
        } else {
            this.lockedSeed = null;
        }
        if ((coords = NBTHelper.getCoordsFromNBT(tag)) != null && coords.length == 3) {
            this.controller = (ISeedStorageController)this.field_145850_b.func_175625_s(this.func_174877_v());
        }
    }

    public void syncSlotToClient(SeedStorageSlot slot) {
        new MessageTileEntitySeedStorage(this.func_174877_v(), slot).sendToDimension(this.field_145850_b.field_73011_w.getDimension());
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        String info = this.getLockedSeed().map(s -> s.getPlant().getPlantName()).orElse("null");
        int mapSize = this.slots == null ? 0 : this.slots.size();
        int listSize = this.slotsList == null ? 0 : this.slotsList.size();
        consumer.accept("Locked Seed: " + info);
        consumer.accept("Nr of map entries: " + mapSize);
        consumer.accept("Nr of list entries: " + listSize);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayInfo(List information) {
        String tool = AgriCore.getTranslator().translate("agricraft_tooltip.storage");
        String none = AgriCore.getTranslator().translate("agricraft_tooltip.none");
        information.add(tool + ": " + this.getLockedSeed().map(s -> s.getPlant().getPlantName()).orElse(none));
        super.addDisplayInfo(information);
    }

    @Override
    public boolean addStackToInventory(ItemStack stack) {
        AgriSeed seed = SeedRegistry.getInstance().valueOf(stack).filter(s -> s.getStat().isAnalyzed()).orElse(null);
        if (seed == null || this.field_145850_b.field_72995_K) {
            return false;
        }
        if (this.lockedSeed == null) {
            this.lockedSeed = seed;
            this.setSlotContents(0, stack);
            return true;
        }
        if (this.lockedSeed.getPlant() == seed.getPlant()) {
            for (Map.Entry<Integer, SeedStorageSlot> entry : this.slots.entrySet()) {
                if (entry.getValue() == null || !ItemStack.func_77970_a((ItemStack)this.lockedSeed.toStack(), (ItemStack)stack)) continue;
                ItemStack newStack = stack.func_77946_l();
                newStack.field_77994_a += entry.getValue().count;
                this.setSlotContents(entry.getKey(), newStack);
                return true;
            }
            int slotId = this.getFirstFreeSlot();
            if (slotId >= 0) {
                this.setSlotContents(slotId, stack);
                return true;
            }
        }
        return false;
    }

    private int getFirstFreeSlot() {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.containsKey(i)) continue;
            return i;
        }
        return this.slots.size();
    }

    @Override
    @Nullable
    public ItemStack getStackForSlotId(int slotId) {
        SeedStorageSlot slot = this.slots.get(slotId);
        if (slot != null) {
            return slot.toStack();
        }
        return null;
    }

    @Override
    public void setSlotContents(int realSlotId, ItemStack inputStack) {
        if (realSlotId < 0) {
            this.addStackToInventory(inputStack);
            return;
        }
        if (this.isValidForSlot(realSlotId, inputStack)) {
            SeedStorageSlot slotAt = this.slots.get(realSlotId);
            if (slotAt != null) {
                slotAt.count = inputStack.field_77994_a;
                if (slotAt.count <= 0) {
                    this.slots.remove(realSlotId);
                    this.slotsList.remove(slotAt);
                }
            } else {
                AgriSeed seed = SeedRegistry.getInstance().valueOf(inputStack).get();
                slotAt = new SeedStorageSlot(seed, inputStack.field_77994_a, realSlotId, this.getControllableID());
                if (slotAt.count > 0) {
                    this.slots.put(realSlotId, slotAt);
                    this.slotsList.add(slotAt);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                this.syncSlotToClient(slotAt);
            } else {
                this.markForUpdate();
            }
        }
    }

    private boolean isValidForSlot(int realSlot, ItemStack stack) {
        AgriSeed seed = SeedRegistry.getInstance().valueOf(stack).orElse(null);
        if (seed == null || !seed.getStat().isAnalyzed()) {
            return false;
        }
        if (this.lockedSeed == null) {
            return true;
        }
        if (this.lockedSeed.getPlant() == seed.getPlant()) {
            SeedStorageSlot slotAt = this.slots.get(realSlot);
            return slotAt == null || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slotAt.getSeed().toStack());
        }
        return false;
    }

    @Override
    public ItemStack decreaseStackSizeInSlot(int realSlotId, int amount) {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stackInSlot = null;
            if (this.slots != null) {
                SeedStorageSlot slotAt = this.slots.get(realSlotId);
                if (slotAt != null) {
                    stackInSlot = slotAt.toStack();
                    stackInSlot.field_77994_a = Math.min(amount, slotAt.count);
                    if (slotAt.count <= amount) {
                        this.slots.remove(realSlotId);
                        this.slotsList.remove(slotAt);
                        slotAt.count = 0;
                    } else {
                        slotAt.count -= amount;
                    }
                }
                this.syncSlotToClient(slotAt);
            }
            return stackInSlot;
        }
        return null;
    }

    public ArrayList<ItemStack> getInventory() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (this.hasLockedSeed()) {
            for (Map.Entry<Integer, SeedStorageSlot> entries : this.slots.entrySet()) {
                if (entries == null || entries.getValue() == null) continue;
                stacks.add(entries.getValue().toStack());
            }
        }
        return stacks;
    }

    @Override
    public List<SeedStorageSlot> getSlots() {
        if (this.slotsList == null) {
            this.slotsList = new ArrayList();
        }
        return this.slotsList;
    }

    @Override
    public int[] getControllerCoords() {
        return this.controller != null ? this.controller.getCoordinates() : null;
    }

    @Override
    public int[] getCoords() {
        return new int[]{this.xCoord(), this.yCoord(), this.zCoord()};
    }

    @Override
    public ISeedStorageController getController() {
        return this.controller;
    }

    @Override
    public boolean hasController() {
        return this.controller != null;
    }

    @Override
    public boolean hasLockedSeed() {
        return this.lockedSeed != null;
    }

    @Override
    public boolean setLockedSeed(AgriSeed seed) {
        if (!this.hasLockedSeed()) {
            this.lockedSeed = seed;
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public void clearLockedSeed() {
        if (this.slots.isEmpty()) {
            this.lockedSeed = null;
            this.markForUpdate();
        }
    }

    @Override
    public Optional<AgriSeed> getLockedSeed() {
        return Optional.ofNullable(this.lockedSeed);
    }

    @Override
    public int getControllableID() {
        int id = -1;
        if (this.hasController()) {
            id = this.getController().getControllableID(this);
        }
        return id;
    }

    public int func_70302_i_() {
        return this.slots.size() + 1;
    }

    public ItemStack func_70301_a(int slot) {
        if (this.slotsList == null || slot >= this.slotsList.size() || !this.hasLockedSeed()) {
            return null;
        }
        return this.slotsList.get(slot).toStack();
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.slotsList == null || slot >= this.slotsList.size() || !this.hasLockedSeed()) {
            return null;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack stackInSlot = null;
            SeedStorageSlot slotAt = this.slotsList.get(slot);
            if (slotAt != null) {
                stackInSlot = slotAt.toStack();
                stackInSlot.field_77994_a = Math.min(amount, slotAt.count);
                if (slotAt.count <= amount) {
                    this.slots.remove(slotAt.getId());
                    this.slotsList.remove(slotAt);
                    slotAt.count = 0;
                } else {
                    slotAt.count -= amount;
                }
            }
            this.syncSlotToClient(slotAt);
            return stackInSlot;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.slotsList == null || slot >= this.slotsList.size() || !this.hasLockedSeed()) {
            return null;
        }
        SeedStorageSlot slotAt = this.slotsList.get(slot);
        ItemStack stackInSlot = slotAt.toStack();
        this.slots.remove(slotAt.getId());
        this.slotsList.remove(slotAt);
        return stackInSlot;
    }

    public void func_70299_a(int slot, ItemStack inputStack) {
        if (this.slotsList == null || slot >= this.slotsList.size()) {
            this.addStackToInventory(inputStack);
            return;
        }
        if (inputStack == null) {
            inputStack = this.slotsList.get(slot).toStack();
            inputStack.field_77994_a = 0;
        }
        if (this.func_94041_b(slot, inputStack)) {
            SeedStorageSlot slotAt = this.slotsList.get(slot);
            if (slotAt != null) {
                slotAt.count = inputStack.field_77994_a;
                if (slotAt.count <= 0) {
                    this.slots.remove(slotAt.getId());
                    this.slotsList.remove(slotAt);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.syncSlotToClient(slotAt);
                }
            } else {
                this.addStackToInventory(inputStack);
            }
        }
    }

    public String func_70005_c_() {
        return "agricraft:seed_storage";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.slotsList = new ArrayList();
        this.slots = new HashMap<Integer, SeedStorageSlot>();
        this.lockedSeed = null;
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        AgriSeed seed = SeedRegistry.getInstance().valueOf(stack).orElse(null);
        if (seed == null || !seed.getStat().isAnalyzed()) {
            return false;
        }
        if (this.hasLockedSeed()) {
            if (this.lockedSeed.getPlant() == seed.getPlant()) {
                if (slot >= this.slotsList.size()) {
                    return true;
                }
                SeedStorageSlot slotAt = this.slotsList.get(slot);
                return slotAt == null || ItemStack.func_77970_a((ItemStack)stack, (ItemStack)this.func_70301_a(slot));
            }
        } else {
            return true;
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] array = new int[this.slotsList.size() + 1];
        for (int i = 0; i < array.length; ++i) {
            array[i] = i;
        }
        return array;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        if (slot >= this.slotsList.size()) {
            return this.func_94041_b(slot, stack);
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return this.slots.containsKey(slot) && this.func_94041_b(slot, stack) && this.slots.get((Object)Integer.valueOf((int)slot)).count > 0;
    }
}

