/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.irrigation.IConnectable;
import com.infinityraider.agricraft.api.irrigation.IIrrigationComponent;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.network.MessageSyncFluidLevel;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.block.multiblock.IMultiBlockComponent;
import com.infinityraider.infinitylib.block.multiblock.MultiBlockManager;
import com.infinityraider.infinitylib.block.multiblock.MultiBlockPartData;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTank
extends TileEntityCustomWood
implements ITickable,
IFluidHandler,
IIrrigationComponent,
IMultiBlockComponent<MultiBlockManager, MultiBlockPartData>,
IDebuggable {
    public static final int SYNC_DELTA = 500;
    public static final int DISCRETE_MAX = 16;
    public static final int SINGLE_CAPACITY = 8000;
    private int fluidLevel = 0;
    private int lastFluidLevel = 0;
    private int lastDiscreteFluidLevel = 0;
    private MultiBlockPartData multiBlockData;
    private TileEntityTank mainComponent;

    @Override
    protected void writeNBT(NBTTagCompound tag) {
        this.getMultiBlockData().writeToNBT(tag);
        if (this.fluidLevel > 0) {
            tag.func_74768_a("agri_level", this.fluidLevel);
        }
    }

    @Override
    protected void readNBT(NBTTagCompound tag) {
        this.fluidLevel = tag.func_74764_b("agri_level") ? tag.func_74762_e("agri_level") : 0;
        this.multiBlockData = new MultiBlockPartData(0, 0, 0, 1, 1, 1);
        this.multiBlockData.readFromNBT(tag);
        this.mainComponent = null;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            Biome biome;
            if (this.field_145850_b.func_175710_j(this.func_174877_v()) && this.field_145850_b.func_72896_J() && !this.hasNeighbour(EnumFacing.UP) && (biome = this.field_145850_b.func_180494_b(this.func_174877_v())).func_76727_i() > 0.0f) {
                this.setFluidLevel(this.getFluidAmount(0) + 1);
            }
            Block block = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(0, 1, 0)).func_177230_c();
            if (AgriCraftConfig.fillFromFlowingWater && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) {
                this.setFluidLevel(this.getFluidAmount(0) + 5);
            }
        }
    }

    @Override
    public void syncFluidLevel() {
        if (this.needsSync()) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.xCoord(), (double)this.yCoord(), (double)this.zCoord(), 64.0);
            new MessageSyncFluidLevel(this.fluidLevel, this.func_174877_v()).sendToAllAround(point);
        }
    }

    private boolean needsSync() {
        int newDiscreteLvl = this.getDiscreteFluidLevel();
        if (newDiscreteLvl != this.lastDiscreteFluidLevel) {
            this.lastDiscreteFluidLevel = newDiscreteLvl;
            this.lastFluidLevel = this.fluidLevel;
            return true;
        }
        if (500 <= Math.abs(this.lastFluidLevel - this.fluidLevel)) {
            this.lastDiscreteFluidLevel = newDiscreteLvl;
            this.lastFluidLevel = this.fluidLevel;
            return true;
        }
        return false;
    }

    public boolean isConnectedToChannel(EnumFacing direction) {
        TileEntity tile;
        if (this.field_145850_b != null && direction != null && direction.func_96559_d() == 0 && (tile = this.func_145831_w().func_175625_s(this.field_174879_c.func_177972_a(direction))) instanceof TileEntityChannel) {
            return ((TileEntityChannel)tile).isSameMaterial(this);
        }
        return false;
    }

    public FluidStack getContents() {
        return new FluidStack(FluidRegistry.WATER, this.getFluidAmount(0));
    }

    @Override
    public int getFluidAmount(int y) {
        if (this.getMainComponent() == this) {
            return this.fluidLevel;
        }
        TileEntityTank mainComponent = this.getMainComponent();
        return mainComponent != null ? mainComponent.getFluidAmount(0) : 0;
    }

    @Override
    public float getFluidHeight(int lvl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getYPosition() {
        return this.getMultiBlockData().posY();
    }

    public int getDiscreteFluidLevel() {
        MultiBlockPartData data = this.getMultiBlockData();
        float discreteFactor = 16.0f / (8000.0f * (float)data.sizeX() * (float)data.sizeZ());
        int discreteFluidLevel = Math.round(discreteFactor * (float)this.getFluidAmount(0));
        if (discreteFluidLevel < 2 && this.getFluidAmount(0) > 0) {
            discreteFluidLevel = 2;
        }
        return discreteFluidLevel;
    }

    @Override
    public int getFluidHeight() {
        return this.getDiscreteFluidLevel();
    }

    @Override
    public boolean canAcceptFluid(int y, int amount, boolean partial) {
        return partial && this.getFluidAmount(0) < this.getCapacity() || this.getFluidAmount(0) + amount <= this.getCapacity();
    }

    @Override
    public int acceptFluid(int y, int amount, boolean partial) {
        if (!this.field_145850_b.field_72995_K && this.canAcceptFluid(y, amount, partial) && amount >= 0) {
            int room = this.getCapacity() - this.getFluidAmount(0);
            if (room >= amount) {
                this.setFluidLevel(this.getFluidAmount(0) + amount);
                amount = 0;
            } else if (room > 0) {
                this.setFluidLevel(this.getCapacity());
                amount -= room;
            }
        }
        return amount;
    }

    @Override
    public void setFluidLevel(int lvl) {
        if (lvl != this.getFluidAmount(0)) {
            TileEntityTank tank = this.getMainComponent();
            int n = lvl > tank.getCapacity() ? tank.getCapacity() : lvl;
            tank.fluidLevel = lvl = n;
            if (!tank.field_145850_b.field_72995_K) {
                tank.syncFluidLevel();
            }
        }
    }

    @Override
    public boolean canConnectTo(EnumFacing side, IConnectable component) {
        return false;
    }

    public Connection getConnectionType(EnumFacing facing) {
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            return Connection.NONE;
        }
        if (this.hasNeighbour(facing)) {
            return Connection.TANK;
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing));
        if (te instanceof TileEntityChannel) {
            return ((TileEntityChannel)te).isSameMaterial(this) ? Connection.CHANNEL : Connection.NONE;
        }
        return Connection.NONE;
    }

    @Override
    public int getCapacity() {
        return 8000 * this.getMultiBlockData().size();
    }

    public boolean isEmpty() {
        return this.getFluidAmount(0) == 0;
    }

    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (resource == null || !this.canFill(from, resource.getFluid())) {
            return 0;
        }
        int filled = Math.min(resource.amount, this.getCapacity() - this.getFluidAmount(0));
        if (doFill && !this.field_145850_b.field_72995_K) {
            this.setFluidLevel(this.getFluidAmount(0) + filled);
        }
        return filled;
    }

    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (resource == null || !this.canDrain(from, resource.getFluid())) {
            return null;
        }
        int drained = Math.min(resource.amount, this.getFluidAmount(0));
        if (doDrain && !this.field_145850_b.field_72995_K) {
            this.setFluidLevel(this.getFluidAmount(0) - drained);
        }
        return new FluidStack(FluidRegistry.WATER, drained);
    }

    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        return this.drain(from, new FluidStack(FluidRegistry.WATER, maxDrain), doDrain);
    }

    public boolean canFill(EnumFacing from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.getFluidAmount(0) != this.getCapacity();
    }

    public boolean canDrain(EnumFacing from, Fluid fluid) {
        return fluid == FluidRegistry.WATER && this.getFluidAmount(0) != 0;
    }

    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        FluidTankInfo[] info = new FluidTankInfo[]{new FluidTankInfo(this.getContents(), this.getCapacity())};
        return info;
    }

    public TileEntityTank getMainComponent() {
        if (this.mainComponent == null) {
            MultiBlockPartData data = this.getMultiBlockData();
            this.mainComponent = WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.func_174877_v().func_177982_a(-data.posX(), -data.posY(), -data.posZ()), TileEntityTank.class).orElse(this);
        }
        return this.mainComponent;
    }

    public MultiBlockManager getMultiBlockManager() {
        return MultiBlockManager.INSTANCE;
    }

    public void setMultiBlockPartData(MultiBlockPartData data) {
        this.multiBlockData = data;
        this.mainComponent = null;
        this.markForUpdate();
    }

    public MultiBlockPartData getMultiBlockData() {
        if (this.multiBlockData == null) {
            this.multiBlockData = new MultiBlockPartData(0, 0, 0, 1, 1, 1);
        }
        return this.multiBlockData;
    }

    public boolean hasNeighbour(EnumFacing dir) {
        MultiBlockPartData data = this.getMultiBlockData();
        int x = data.posX() + dir.func_82601_c();
        int y = data.posY() + dir.func_96559_d();
        int z = data.posZ() + dir.func_82599_e();
        return x >= 0 && x < data.sizeX() && y >= 0 && y < data.sizeY() && z >= 0 && z < data.sizeZ();
    }

    public boolean isValidComponent(IMultiBlockComponent component) {
        return component instanceof TileEntityTank && this.isSameMaterial((TileEntityTank)component);
    }

    public void preMultiBlockCreation(int sizeX, int sizeY, int sizeZ) {
        int lvl = 0;
        for (int x = 0; x < sizeX; ++x) {
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(this.xCoord(), this.yCoord(), this.zCoord()));
                    if (tank == null) continue;
                    lvl += tank.fluidLevel;
                    tank.fluidLevel = 0;
                }
            }
        }
        this.fluidLevel = lvl;
    }

    public void postMultiBlockCreation() {
        this.mainComponent = null;
    }

    public void preMultiBlockBreak() {
        MultiBlockPartData data = this.getMultiBlockData();
        int[] fluidLevelByLayer = new int[data.sizeY()];
        int area = data.sizeX() * data.sizeZ();
        int fluidContentByLayer = area * 8000;
        for (int layer = 0; this.fluidLevel > 0 && layer < fluidLevelByLayer.length; ++layer) {
            fluidLevelByLayer[layer] = this.fluidLevel >= fluidContentByLayer ? fluidContentByLayer / area : this.fluidLevel / area;
            this.fluidLevel = this.fluidLevel >= fluidContentByLayer ? this.fluidLevel - fluidContentByLayer : 0;
        }
        for (int x = 0; x < data.sizeX(); ++x) {
            for (int y = 0; y < fluidLevelByLayer.length; ++y) {
                for (int z = 0; z < data.sizeZ(); ++z) {
                    TileEntityTank tank = (TileEntityTank)this.field_145850_b.func_175625_s(this.func_174877_v().func_177982_a(this.xCoord(), this.yCoord(), this.zCoord()));
                    if (tank == null) continue;
                    tank.fluidLevel = fluidLevelByLayer[y];
                }
            }
        }
    }

    public void postMultiBlockBreak() {
        this.mainComponent = null;
        this.syncFluidLevel();
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        super.addServerDebugInfo(consumer);
        MultiBlockPartData data = this.getMultiBlockData();
        TileEntityTank root = this.getMainComponent();
        consumer.accept("TANK:");
        consumer.accept("coordinates: (" + this.xCoord() + ", " + this.yCoord() + ", " + this.zCoord() + ")");
        consumer.accept("root coords: (" + root.xCoord() + ", " + root.yCoord() + ", " + root.zCoord() + ")");
        consumer.accept("Tank: (single capacity: 8000)");
        consumer.accept("  - FluidLevel: " + this.getFluidAmount(0) + "/" + this.getCapacity());
        consumer.accept("  - Water level is on layer " + (int)Math.floor(((float)this.getFluidAmount(0) - 0.1f) / (float)(this.getCapacity() * data.sizeX() * data.sizeZ())) + ".");
        consumer.accept("  - Water height is " + this.getFluidHeight());
        StringBuilder neighbours = new StringBuilder();
        for (EnumFacing dir : EnumFacing.values()) {
            if (dir == null || !this.hasNeighbour(dir)) continue;
            neighbours.append(dir.name()).append(", ");
        }
        consumer.accept("  - Neighbours: " + neighbours.toString());
        consumer.accept("  - MultiBlock data: " + data.toString());
        consumer.accept("  - MultiBlock Size: " + data.sizeX() + "x" + data.sizeY() + "x" + data.sizeZ());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayInfo(List information) {
        super.addDisplayInfo(information);
        information.add(AgriCore.getTranslator().translate("agricraft_tooltip.waterLevel") + ": " + this.getFluidAmount(0) + "/" + this.getCapacity());
    }

    public static enum Connection implements IStringSerializable
    {
        NONE,
        TANK,
        CHANNEL;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

