/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.infinityraider.agricraft.api.irrigation.IConnectable;
import com.infinityraider.agricraft.api.irrigation.IIrrigationComponent;
import com.infinityraider.agricraft.blocks.irrigation.BlockWaterChannel;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.renderers.particles.LiquidSprayFX;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.agricraft.utility.BlockRange;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.utility.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySprinkler
extends TileEntityBase
implements ITickable,
IIrrigationComponent {
    public static final int BUFFER_CAP = 100;
    public static final int RADIUS = 3;
    public static final int HEIGHT = 5;
    private int buffer = 0;
    private int counter = 0;
    private float angle = 0.0f;
    private boolean active = false;
    private final BlockRange range = new BlockRange(this.func_174877_v().func_177982_a(-3, 1, -3), this.func_174877_v().func_177982_a(3, 5, 3));

    public float getAngle() {
        return this.angle;
    }

    public void writeTileNBT(NBTTagCompound tag) {
        if (this.counter > 0) {
            tag.func_74768_a("agri_level", this.counter);
        }
        tag.func_74757_a("agri_sprinkled", this.active);
    }

    public void readTileNBT(NBTTagCompound tag) {
        this.counter = tag.func_74764_b("agri_level") ? tag.func_74762_e("agri_level") : 0;
        this.active = tag.func_74764_b("agri_sprinkled") ? tag.func_74767_n("agri_sprinkled") : false;
    }

    public boolean isConnected() {
        return this.field_145850_b != null && this.field_145850_b.func_180495_p(this.func_174877_v().func_177982_a(0, 1, 0)).func_177230_c() instanceof BlockWaterChannel;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.isActive()) {
            this.counter = (this.counter + 1) % AgriCraftConfig.sprinklerGrowthIntervalTicks;
            this.buffer -= 10;
            this.range.stream().forEach(p -> this.irrigate((BlockPos)p, false));
        } else if (this.active) {
            this.renderLiquidSpray();
        }
    }

    @Override
    public boolean canConnectTo(EnumFacing side, IConnectable component) {
        return side.equals((Object)EnumFacing.UP) && component instanceof TileEntityChannel;
    }

    @Override
    public boolean canAcceptFluid(int y, int amount, boolean partial) {
        if (this.buffer + amount <= 100) {
            return true;
        }
        return partial;
    }

    @Override
    public int acceptFluid(int y, int amount, boolean partial) {
        if (this.canAcceptFluid(y, amount, partial)) {
            this.buffer += amount;
            if (this.buffer > 100) {
                amount = this.buffer - 100;
                this.buffer = 100;
            } else {
                amount = 0;
            }
        }
        return amount;
    }

    @Override
    public int getFluidAmount(int y) {
        return this.buffer;
    }

    @Override
    public int getCapacity() {
        return 100;
    }

    @Override
    public void setFluidLevel(int lvl) {
    }

    @Override
    public void syncFluidLevel() {
    }

    @Override
    public int getFluidHeight() {
        return this.buffer;
    }

    @Override
    public float getFluidHeight(int lvl) {
        return (float)this.buffer * 16.0f / 100.0f;
    }

    public boolean canSprinkle() {
        return WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), TileEntityChannel.class).filter(c -> c.getFluidAmount(0) > AgriCraftConfig.sprinklerRatePerHalfSecond).isPresent();
    }

    private boolean isActive() {
        boolean newState = this.canSprinkle();
        if (newState != this.active) {
            this.active = newState;
            this.markForUpdate();
        }
        return this.active;
    }

    private void irrigate(BlockPos pos, boolean farmlandOnly) {
        IBlockState state = this.func_145831_w().func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockFarmland && block.func_176201_c(state) < 7) {
            int flag = this.counter == 0 ? 2 : 6;
            this.field_145850_b.func_180501_a(pos, block.func_176203_a(7), flag);
        } else if (!farmlandOnly && (block instanceof IPlantable || block instanceof IGrowable) && this.counter == 0 && this.field_145850_b.field_73012_v.nextDouble() <= (double)AgriCraftConfig.sprinklerGrowthChancePercent) {
            block.func_180650_b(this.func_145831_w(), pos, state, this.field_145850_b.field_73012_v);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getChannelIcon() {
        return WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(0, 1, 0), TileEntityChannel.class).map(c -> c.getIcon()).orElse(BaseIcons.OAK_PLANKS.getIcon());
    }

    @SideOnly(value=Side.CLIENT)
    private void renderLiquidSpray() {
        if (AgriCraftConfig.disableParticles) {
            return;
        }
        this.angle = (this.angle + 5.0f) % 360.0f;
        int particleSetting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        this.counter = (this.counter + 1) % (particleSetting + 1);
        if (this.counter == 0) {
            for (int i = 0; i < 4; ++i) {
                float alpha = -(this.angle + (float)(90 * i)) * (float)Math.PI / 180.0f;
                double xOffset = 0.25 * Math.cos(alpha);
                double zOffset = 0.25 * Math.sin(alpha);
                float radius = 0.3f;
                for (int j = 0; j <= 4; ++j) {
                    float beta = (float)(-j) * (float)Math.PI / 8.0f;
                    Vec3d vector = new Vec3d((double)radius * Math.cos(alpha), (double)radius * Math.sin(beta), (double)radius * Math.sin(alpha));
                    this.spawnLiquidSpray(xOffset * (double)(4 - j) / 4.0, zOffset * (double)(4 - j) / 4.0, vector);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnLiquidSpray(double xOffset, double zOffset, Vec3d vector) {
        LiquidSprayFX liquidSpray = new LiquidSprayFX(this.field_145850_b, (double)((float)this.xCoord() + 0.5f) + xOffset, (float)this.yCoord() + 0.5f, (double)((float)this.zCoord() + 0.5f) + zOffset, 0.3f, 0.7f, vector);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)liquidSpray);
    }
}

