/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.block.blockstate.SidedConnection;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityChannelValve
extends TileEntityChannel
implements IDebuggable {
    private boolean powered = false;
    private SidedConnection levers = new SidedConnection();

    @Override
    protected final void writeChannelNBT(NBTTagCompound tag) {
        tag.func_74757_a("agri_power", this.powered);
        this.levers.writeToNBT(tag);
    }

    @Override
    protected final void readChannelNBT(NBTTagCompound tag) {
        this.powered = tag.func_74767_n("agri_power");
        this.levers.readFromNBT(tag);
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.powered) {
                super.func_73660_a();
            } else if (++this.ticksSinceNeighbourCheck > 1024) {
                this.checkConnections();
                this.ticksSinceNeighbourCheck = 0;
            }
        }
    }

    public void updatePowerStatus() {
        boolean wasPowered = this.powered;
        boolean bl = this.powered = this.field_145850_b.func_175687_A(this.func_174877_v()) > 0;
        if (this.powered != wasPowered) {
            this.markForUpdate();
        }
    }

    public void updateLevers() {
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            IBlockState neighbour = this.func_145831_w().func_180495_p(this.func_174877_v().func_177982_a(dir.func_82601_c(), 0, dir.func_82599_e()));
            this.levers.setConnected(dir, neighbour.func_177230_c() instanceof BlockLever && ((BlockLever.EnumOrientation)neighbour.func_177229_b((IProperty)BlockLever.field_176360_a)).func_176852_c() == dir);
        }
        this.markForUpdate();
    }

    public IExtendedBlockState addLeversToState(IExtendedBlockState state) {
        return state.withProperty(AgriProperties.CONNECTIONS, (Object)this.levers);
    }

    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public boolean canAcceptFluid(int y, int amount, boolean partial) {
        return !this.powered && super.canAcceptFluid(y, amount, partial);
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("VALVE");
        consumer.accept("  - State: " + (this.isPowered() ? "closed" : "open"));
        consumer.accept("  - FluidLevel: " + this.getFluidAmount(0) + "/" + 500);
        consumer.accept("  - FluidHeight: " + this.getFluidHeight());
        consumer.accept("  - Material: " + this.getMaterialBlock().getRegistryName() + ":" + this.getMaterialMeta());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayInfo(List information) {
        super.addDisplayInfo(information);
        String status = AgriCore.getTranslator().translate(this.powered ? "agricraft_tooltip.closed" : "agricraft_tooltip.open");
        information.add(AgriCore.getTranslator().translate("agricraft_tooltip.state") + ": " + status);
    }
}

