/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.decoration;

import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityGrate
extends TileEntityCustomWood
implements IDebuggable {
    private static final double WIDTH = 0.125;
    private static final double LENGTH = 1.0;
    private EnumOffset offset = EnumOffset.NEAR;
    private EnumVines vines = EnumVines.NONE;
    private EnumFacing.Axis axis = EnumFacing.Axis.X;
    private double[] bounds;

    @Override
    protected void writeNBT(NBTTagCompound tag) {
        tag.func_74777_a("agri_meta", (short)this.offset.ordinal());
        tag.func_74777_a("agri_vine", (short)this.vines.ordinal());
        tag.func_74777_a("agri_axis", (short)this.axis.ordinal());
    }

    @Override
    protected void readNBT(NBTTagCompound tag) {
        this.offset = EnumOffset.values()[tag.func_74765_d("agri_meta") % EnumOffset.values().length];
        this.vines = EnumVines.values()[tag.func_74765_d("agri_vine") % EnumVines.values().length];
        this.axis = EnumFacing.Axis.values()[tag.func_74765_d("agri_axis") % EnumFacing.Axis.values().length];
        this.calculateBounds();
    }

    public EnumOffset getOffset() {
        return this.offset;
    }

    public TileEntityGrate setOffSet(EnumOffset offSet) {
        if (offSet != this.getOffset()) {
            this.offset = offSet;
            this.markForUpdate();
        }
        return this;
    }

    public EnumFacing.Axis getAxis() {
        return this.axis;
    }

    public TileEntityGrate setAxis(EnumFacing.Axis axis) {
        if (axis != this.getAxis()) {
            this.axis = axis;
            this.markForUpdate();
        }
        return this;
    }

    public TileEntityGrate setAxis(EnumFacing facing) {
        return facing == null ? this : this.setAxis(facing.func_176740_k());
    }

    public EnumVines getVines() {
        return this.vines;
    }

    public TileEntityGrate setVines(EnumVines vines) {
        if (vines != this.getVines()) {
            this.vines = vines;
            this.markForUpdate();
        }
        return this;
    }

    public boolean hasVines(boolean front) {
        return this.getVines().hasVines(front);
    }

    public boolean addVines(boolean front) {
        EnumVines vines = this.getVines().addVines(front);
        if (vines != this.getVines()) {
            this.setVines(vines);
            return true;
        }
        return false;
    }

    public boolean removeVines(boolean front) {
        EnumVines vines = this.getVines().removeVines(front);
        if (vines != this.getVines()) {
            this.setVines(vines);
            return true;
        }
        return false;
    }

    public void calculateBounds() {
        float offset = this.getOffset().getOffset();
        if (null != this.getOrientation()) {
            switch (this.getOrientation()) {
                default: {
                    this.bounds = new double[]{0.0, 0.0, offset, 1.0, 1.0, (double)offset + 0.125};
                    break;
                }
                case EAST: {
                    this.bounds = new double[]{offset, 0.0, 0.0, (double)offset + 0.125, 1.0, 1.0};
                    break;
                }
                case DOWN: {
                    this.bounds = new double[]{0.0, offset, 0.0, 1.0, (double)offset + 0.125, 1.0};
                }
            }
        }
    }

    public boolean isPlayerInFront(EntityPlayer player) {
        float offset = this.getOffset().getOffset();
        switch (this.getOrientation()) {
            default: {
                return player.field_70161_v < (double)((float)this.zCoord() + offset + 0.0625f);
            }
            case EAST: {
                return player.field_70165_t < (double)((float)this.xCoord() + offset + 0.0625f);
            }
            case DOWN: 
        }
        return player.field_70163_u < (double)((float)this.yCoord() + offset + 0.0625f);
    }

    public AxisAlignedBB getBoundingBox() {
        float offset = this.getOffset().getOffset();
        switch (this.getOrientation()) {
            default: {
                return new AxisAlignedBB((double)this.xCoord(), (double)this.yCoord(), (double)((float)this.zCoord() + offset), (double)this.xCoord() + 1.0, (double)this.yCoord() + 1.0, (double)((float)this.zCoord() + offset) + 0.125);
            }
            case EAST: {
                return new AxisAlignedBB((double)((float)this.xCoord() + offset), (double)this.yCoord(), (double)this.zCoord(), (double)((float)this.xCoord() + offset) + 0.125, (double)this.yCoord() + 1.0, (double)this.zCoord() + 1.0);
            }
            case DOWN: 
        }
        return new AxisAlignedBB((double)this.xCoord(), (double)((float)this.yCoord() + offset), (double)this.zCoord(), (double)this.xCoord() + 1.0, (double)((float)this.yCoord() + offset) + 0.125, (double)this.zCoord() + 1.0);
    }

    public double[] getBlockBounds() {
        return this.bounds;
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("GRATE:");
        super.addServerDebugInfo(consumer);
        consumer.accept("Offset: " + (Object)((Object)this.offset));
        consumer.accept("Orientation: " + this.getOrientation() + " (" + (this.getOrientation() == EnumFacing.NORTH ? "xy" : (this.getOrientation() == EnumFacing.EAST ? "zy" : "xz")) + ")");
        consumer.accept("Bounds: ");
        consumer.accept(" - x: " + this.bounds[0] + " - " + this.bounds[3]);
        consumer.accept(" - y: " + this.bounds[1] + " - " + this.bounds[4]);
        consumer.accept(" - z: " + this.bounds[2] + " - " + this.bounds[5]);
    }

    public static enum EnumOffset implements IStringSerializable
    {
        NEAR(0.0f),
        CENTER(0.4375f),
        FAR(0.875f);

        private final float offset;

        private EnumOffset(float offset) {
            this.offset = offset;
        }

        public float getOffset() {
            return this.offset;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnumVines implements IStringSerializable
    {
        NONE(false, false),
        FRONT(true, true),
        BACK(true, false),
        BOTH(true, true);

        private final boolean vines;
        private final boolean front;

        private EnumVines(boolean hasVines, boolean front) {
            this.vines = hasVines;
            this.front = front;
        }

        public boolean hasVines(boolean front) {
            return this.vines && this.front == front;
        }

        public EnumVines addVines(boolean front) {
            if (this.hasVines(front)) {
                return this;
            }
            return EnumVines.values()[this.ordinal() + (front ? 1 : 2)];
        }

        public EnumVines removeVines(boolean front) {
            if (!this.hasVines(front)) {
                return this;
            }
            return EnumVines.values()[this.ordinal() - (front ? 1 : 2)];
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

