/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.misc.IAgriDisplayable;
import com.infinityraider.agricraft.utility.CustomWoodType;
import com.infinityraider.infinitylib.block.tile.TileEntityRotatableBase;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCustomWood
extends TileEntityRotatableBase
implements IDebuggable,
IAgriDisplayable {
    @Nonnull
    private CustomWoodType woodType = CustomWoodType.getDefault();

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public TextureAtlasSprite getIcon() {
        return this.woodType.getIcon();
    }

    protected final void writeRotatableTileNBT(NBTTagCompound tag) {
        this.woodType.writeToNBT(tag);
        this.writeNBT(tag);
    }

    protected void writeNBT(NBTTagCompound tag) {
    }

    protected final void readRotatableTileNBT(NBTTagCompound tag) {
        this.setMaterial(CustomWoodType.readFromNBT(tag));
        this.readNBT(tag);
    }

    protected void readNBT(NBTTagCompound tag) {
    }

    public final boolean isSameMaterial(TileEntityCustomWood tileEntity) {
        return tileEntity != null && this.func_145832_p() == tileEntity.func_145832_p() && this.getMaterialBlock() == tileEntity.getMaterialBlock() && this.getMaterialMeta() == tileEntity.getMaterialMeta();
    }

    public final void setMaterial(CustomWoodType type) {
        this.woodType = type;
    }

    public final void setMaterial(ItemStack stack) {
        this.setMaterial(CustomWoodType.readFromNBT(stack.func_77978_p()));
    }

    public final void setMaterial(Block block, int meta) {
        if (block != null) {
            this.setMaterial(CustomWoodType.getFromBlockAndMeta(block, meta));
        }
    }

    public final CustomWoodType getMaterial() {
        return this.woodType;
    }

    public final Block getMaterialBlock() {
        return this.getMaterial().getBlock();
    }

    public final IBlockState getMaterialState() {
        return this.getMaterial().getState();
    }

    public final int getMaterialMeta() {
        return this.getMaterial().getMeta();
    }

    public final ItemStack getMaterialStack() {
        return this.getMaterial().getStack();
    }

    public final NBTTagCompound getMaterialTag() {
        return this.getMaterial().writeToNBT(new NBTTagCompound());
    }

    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("this material is: " + this.getMaterialBlock().getRegistryName() + ":" + this.getMaterialMeta());
    }

    public void addDisplayInfo(List information) {
        information.add(AgriCore.getTranslator().translate("agricraft_tooltip.material") + ": " + this.getMaterialStack().func_82833_r());
    }
}

