/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.TypeHelper;
import com.infinityraider.agricraft.api.crop.IAdditionalCropData;
import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.api.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.misc.IAgriDisplayable;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.api.soil.IAgriSoil;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.apiimpl.FertilizerRegistry;
import com.infinityraider.agricraft.apiimpl.MutationEngine;
import com.infinityraider.agricraft.apiimpl.PlantRegistry;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.apiimpl.SoilRegistry;
import com.infinityraider.agricraft.apiimpl.StatRegistry;
import com.infinityraider.agricraft.blocks.BlockCrop;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.items.ItemDebugger;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCrop
extends TileEntityBase
implements IAgriCrop,
IDebuggable,
IAgriDisplayable {
    public static final Class[] ITEM_EXCLUDES = new Class[]{IAgriRakeItem.class, IAgriClipperItem.class, IAgriTrowelItem.class, ItemDebugger.class};
    private int growthStage;
    private boolean crossCrop = false;
    private IAgriStat stats;
    private IAgriPlant plant;
    private IAdditionalCropData data;

    public void growthTick() {
        if (!this.isRemote()) {
            if (this.plant != null && this.stats != null) {
                if (this.isMature()) {
                    this.spread();
                } else if ((double)this.stats.getGrowth() * this.plant.getGrowthBonus() * (double)AgriCraftConfig.growthMultiplier > this.getRandom().nextDouble() && this.isFertile()) {
                    this.applyGrowthTick();
                }
            } else if (this.isCrossCrop() && (double)AgriCraftConfig.crossOverChance > this.getRandom().nextDouble()) {
                this.crossOver();
            } else {
                this.spawn();
            }
        }
    }

    public boolean plantSeed(EntityPlayer player, ItemStack stack) {
        boolean success = false;
        if (!(this.isRemote() || this.isCrossCrop() || this.hasPlant())) {
            Optional<AgriSeed> seed = SeedRegistry.getInstance().valueOf(stack);
            boolean bl = success = seed.isPresent() && seed.get().getPlant().getGrowthRequirement().isMet(this.func_145831_w(), this.field_174879_c) && this.setSeed(seed.get());
        }
        if (success && !player.func_184812_l_()) {
            --stack.field_77994_a;
        }
        return success;
    }

    public boolean onCropRightClicked(EntityPlayer player, ItemStack heldItem) {
        if (!this.isRemote()) {
            if (AgriItems.getInstance().HAND_RAKE.isEnabled() && heldItem == null && this.canWeed()) {
                return false;
            }
            if (player.func_70093_af() || heldItem == null) {
                this.harvest(player);
            } else {
                if (TypeHelper.isAnyType(heldItem.func_77973_b(), ITEM_EXCLUDES)) {
                    return false;
                }
                if (FertilizerRegistry.getInstance().hasAdapter(heldItem)) {
                    Optional<IAgriFertilizer> fert = FertilizerRegistry.getInstance().valueOf(heldItem);
                    return fert.isPresent() && fert.get().applyFertilizer(player, this.func_145831_w(), this.func_174877_v(), this, heldItem, this.getRandom());
                }
                if (this.plantSeed(player, heldItem)) {
                    return true;
                }
                if (heldItem.func_77973_b() == AgriItems.getInstance().CROPS) {
                    if (!player.func_184812_l_()) {
                        --heldItem.field_77994_a;
                    }
                    this.setCrossCrop(true);
                } else {
                    this.harvest(player);
                }
            }
        }
        return true;
    }

    public void onCropLeftClicked(EntityPlayer player) {
        if (!this.isRemote()) {
            if (!player.field_71075_bZ.field_75098_d) {
                this.getDrops(arg_0 -> ((TileEntityCrop)this).spawnAsEntity(arg_0));
            }
            if (this.hasPlant()) {
                this.getPlant().ifPresent(p -> p.onRemove(this.func_145831_w(), this.field_174879_c));
            }
            this.func_145831_w().func_175713_t(this.field_174879_c);
            this.func_145831_w().func_175698_g(this.field_174879_c);
        }
    }

    public void getDrops(Consumer<ItemStack> consumer) {
        consumer.accept(new ItemStack((Item)AgriItems.getInstance().CROPS, this.isCrossCrop() ? 2 : 1));
        this.getSeed().ifPresent(seed -> consumer.accept(seed.toStack()));
        if (this.isMature()) {
            this.getFruits(consumer);
        }
    }

    public void applyBoneMeal() {
        if (!this.isRemote()) {
            if (this.hasPlant() || this.canWeed()) {
                this.setGrowthStage(this.growthStage + 2 + this.getRandom().nextInt(3));
            } else if (this.isCrossCrop() && AgriCraftConfig.fertilizerMutation) {
                this.crossOver();
            }
        }
    }

    @Override
    public final boolean hasPlant() {
        return this.plant != null;
    }

    @Override
    @Nonnull
    public final Optional<IAgriPlant> getPlant() {
        return Optional.ofNullable(this.plant);
    }

    @Override
    public final boolean hasStat() {
        return this.stats != null;
    }

    @Override
    @Nonnull
    public final Optional<IAgriStat> getStat() {
        return Optional.ofNullable(this.stats);
    }

    @Override
    public boolean isCrossCrop() {
        return this.crossCrop;
    }

    @Override
    public void setCrossCrop(boolean status) {
        if (!this.isRemote() && !this.hasPlant()) {
            this.crossCrop = status;
            SoundType type = Blocks.field_150344_f.getSoundType(null, null, null, null);
            this.field_145850_b.func_184148_a(null, (double)((float)this.xCoord() + 0.5f), (double)((float)this.yCoord() + 0.5f), (double)((float)this.zCoord() + 0.5f), type.func_185841_e(), SoundCategory.BLOCKS, (type.func_185843_a() + 1.0f) / 2.0f, type.func_185847_b() * 0.8f);
            this.markForUpdate();
        }
    }

    @Override
    public int getGrowthStage() {
        return this.growthStage;
    }

    @Override
    public void setGrowthStage(int stage) {
        if (!this.isRemote() && this.hasPlant() && this.stats != null) {
            if (stage < 0) {
                stage = 0;
            } else if (stage >= this.plant.getGrowthStages()) {
                stage = this.plant.getGrowthStages() - 1;
            }
            if (stage != this.growthStage) {
                this.growthStage = stage;
                this.markForUpdate();
            }
        }
    }

    @Override
    public boolean acceptsPlant(IAgriPlant plant) {
        return plant != null && !this.hasPlant() && !this.isCrossCrop();
    }

    @Override
    public boolean setPlant(IAgriPlant plant) {
        if (!(this.isRemote() || this.crossCrop || this.hasPlant() || plant == null)) {
            this.plant = plant;
            plant.onPlanted(this.field_145850_b, this.field_174879_c);
            IAdditionalCropData new_data = plant.getInitialCropData(this.field_145850_b, this.func_174877_v(), this);
            if (new_data != null) {
                this.data = new_data;
            }
            this.markForUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Optional<IAgriPlant> removePlant() {
        if (!this.isRemote()) {
            IAgriPlant oldPlant = this.plant;
            this.plant = null;
            this.data = null;
            if (oldPlant != null) {
                oldPlant.onRemove(this.field_145850_b, this.field_174879_c);
            }
            this.markForUpdate();
            return Optional.ofNullable(oldPlant);
        }
        return Optional.empty();
    }

    @Override
    public boolean acceptsStat(IAgriStat stat) {
        return true;
    }

    @Override
    public boolean setStat(IAgriStat stat) {
        if (!this.isRemote()) {
            this.stats = stat;
            return stat != null;
        }
        return false;
    }

    @Override
    public Optional<IAgriStat> removeStat() {
        if (!this.isRemote()) {
            IAgriStat old = this.stats;
            this.stats = new PlantStats();
            this.markForUpdate();
            return Optional.ofNullable(old);
        }
        return Optional.empty();
    }

    @Override
    public boolean isFertile(IAgriPlant plant) {
        return this.field_145850_b.func_175623_d(this.field_174879_c.func_177984_a()) && plant.getGrowthRequirement().isMet(this.field_145850_b, this.field_174879_c);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCropHeight() {
        return this.hasPlant() ? this.plant.getHeight(this.func_145832_p()) : 0.8125f;
    }

    @Override
    public boolean isMature() {
        return this.getPlant().map(plant -> this.growthStage + 1 >= plant.getGrowthStages()).orElse(false);
    }

    @Override
    public Optional<IAgriSoil> getSoil() {
        return SoilRegistry.getInstance().getSoil(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
    }

    @Override
    public boolean spawn() {
        if (!this.isRemote() && !this.hasPlant()) {
            for (IAgriPlant p : PlantRegistry.getInstance().getPlants()) {
                if (!(p.getSpawnChance() > this.getRandom().nextDouble()) || !this.isFertile(p)) continue;
                this.setCrossCrop(false);
                this.setStat(new PlantStats());
                this.setPlant(p);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean spread() {
        if (!this.isRemote() && this.hasPlant() && this.plant.getSpreadChance() > this.getRandom().nextDouble()) {
            for (IAgriCrop crop : this.getNeighbours()) {
                if (this.getPlant().equals(crop.getPlant())) continue;
                if (!crop.hasPlant() && !crop.isCrossCrop()) {
                    crop.setPlant(this.plant);
                    return true;
                }
                if (!this.plant.isAggressive() || !((double)crop.getStat().map(s -> s.getStrength()).orElse((byte)0).byteValue() > (double)this.getStat().map(s -> s.getStrength()).orElse((byte)0).byteValue() * this.getRandom().nextDouble())) continue;
                crop.setCrossCrop(false);
                crop.setPlant(this.plant);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean clearWeed() {
        if (!this.isRemote() && this.plant != null && this.plant.isWeed()) {
            this.removePlant();
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsFertilizer(IAgriFertilizer fertilizer) {
        if (this.crossCrop) {
            return AgriCraftConfig.fertilizerMutation && fertilizer.canTriggerMutation();
        }
        return this.hasPlant() && this.plant.isFertilizable() && fertilizer.isFertilizerAllowed(this.plant.getTier());
    }

    @Override
    public boolean onApplyFertilizer(IAgriFertilizer fertilizer, Random rand) {
        if (this.hasPlant() && this.plant.isFertilizable() && this.getGrowthStage() < 7) {
            ((BlockCrop)AgriBlocks.getInstance().CROP).func_176474_b(this.func_145831_w(), rand, this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()));
            return true;
        }
        if (this.isCrossCrop() && AgriCraftConfig.fertilizerMutation && fertilizer.canTriggerMutation()) {
            this.crossOver();
            return true;
        }
        return false;
    }

    @Override
    public boolean canHarvest() {
        return this.hasPlant() && this.isMature();
    }

    @Override
    public boolean harvest(@Nullable EntityPlayer player) {
        if (!this.isRemote()) {
            if (this.canWeed()) {
                this.clearWeed();
                return false;
            }
            if (this.isCrossCrop()) {
                this.setCrossCrop(false);
                this.spawnAsEntity(new ItemStack((Item)AgriItems.getInstance().CROPS, 1));
                return false;
            }
            if (this.canHarvest()) {
                this.setGrowthStage(0);
                this.getFruits(arg_0 -> ((TileEntityCrop)this).spawnAsEntity(arg_0));
                return true;
            }
        }
        return false;
    }

    @Override
    public void getFruits(Consumer<ItemStack> consumer) {
        if (this.plant != null && this.stats != null) {
            this.plant.getFruitsOnHarvest(this.stats, consumer, this.getRandom());
        }
    }

    @Override
    public TileEntity getTileEntity() {
        return this;
    }

    @Override
    public IAdditionalCropData getAdditionalCropData() {
        return this.data;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (this.hasPlant()) {
            this.plant.onValidate(this.field_145850_b, this.field_174879_c, this);
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hasPlant()) {
            this.plant.onInvalidate(this.field_145850_b, this.field_174879_c, this);
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hasPlant()) {
            this.plant.onChunkUnload(this.field_145850_b, this.field_174879_c, this);
        }
    }

    public void writeTileNBT(NBTTagCompound tag) {
        if (this.stats != null) {
            this.stats.writeToNBT(tag);
            tag.func_74768_a("agri_meta", this.growthStage);
        }
        tag.func_74757_a("agri_cross_crop", this.crossCrop);
        if (this.plant != null) {
            tag.func_74778_a("agri_seed", this.plant.getId());
        }
        if (this.getAdditionalCropData() != null) {
            tag.func_74782_a("agri_inventory", (NBTBase)this.getAdditionalCropData().writeToNBT());
        }
    }

    public void readTileNBT(NBTTagCompound tag) {
        this.stats = StatRegistry.getInstance().valueOf(tag).orElse(null);
        if (tag.func_74764_b("agri_meta")) {
            this.growthStage = tag.func_74762_e("agri_meta");
        }
        this.crossCrop = tag.func_74767_n("agri_cross_crop");
        this.plant = PlantRegistry.getInstance().getPlant(tag.func_74779_i("agri_seed"));
        if (tag.func_74764_b("agri_inventory") && this.plant != null) {
            this.data = this.plant.readCropDataFromNBT(tag.func_74775_l("agri_inventory"));
        }
    }

    public void applyGrowthTick() {
        int meta = this.getGrowthStage();
        if (!this.isRemote() && this.hasPlant() && this.growthStage < this.plant.getGrowthStages()) {
            this.plant.onAllowedGrowthTick(this.field_145850_b, this.field_174879_c, this, meta);
            this.setGrowthStage(meta + 1);
        }
    }

    public void crossOver() {
        MutationEngine.getInstance().attemptCross(this, this.field_145850_b.field_73012_v);
    }

    @Override
    public List<IAgriCrop> getNeighbours() {
        return WorldHelper.getTileNeighbors((World)this.field_145850_b, (BlockPos)this.field_174879_c, IAgriCrop.class);
    }

    @Override
    public List<IAgriCrop> getMatureNeighbours() {
        List<IAgriCrop> neighbours = this.getNeighbours();
        neighbours.removeIf(p -> !p.hasPlant() || !p.isMature());
        return neighbours;
    }

    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("CROP:");
        if (this.crossCrop) {
            consumer.accept(" - This is a crosscrop");
        } else if (this.hasSeed()) {
            if (this.plant.isWeed()) {
                consumer.accept(" - This crop has weeds");
            } else {
                consumer.accept(" - This crop has a plant");
            }
            Optional<IAgriStat> stats = this.getStat();
            consumer.accept(" - Plant: " + this.plant.getPlantName());
            consumer.accept(" - Id: " + this.plant.getId());
            consumer.accept(" - Tier: " + this.plant.getTier());
            consumer.accept(" - Stage: " + this.getGrowthStage());
            consumer.accept(" - Stages: " + this.plant.getGrowthStages());
            consumer.accept(" - Meta: " + this.getGrowthStage());
            consumer.accept(" - Growth: " + stats.map(IAgriStat::getGrowth).orElse((byte)1));
            consumer.accept(" - Gain: " + stats.map(IAgriStat::getGain).orElse((byte)1));
            consumer.accept(" - Strength: " + stats.map(IAgriStat::getStrength).orElse((byte)1));
            consumer.accept(" - Fertile: " + this.isFertile());
            consumer.accept(" - Mature: " + this.isMature());
            consumer.accept(" - AgriSoil: " + this.plant.getGrowthRequirement().getSoils().stream().findFirst().map(IAgriSoil::getId).orElse("None"));
        } else {
            consumer.accept(" - This crop has no plant");
        }
    }

    public void addClientDebugInfo(Consumer<String> consumer) {
        consumer.accept(" - Texture: " + this.plant.getPrimaryPlantTexture(this.getGrowthStage()).toString());
    }

    @Override
    public void addDisplayInfo(List<String> information) {
        information.add("Soil: " + this.getSoil().map(IAgriSoil::getName).orElse("Unknown"));
        if (this.hasPlant()) {
            information.add(AgriCore.getTranslator().translate("agricraft_tooltip.seed") + ": " + this.plant.getSeedName());
            if (this.isMature()) {
                information.add(AgriCore.getTranslator().translate("agricraft_tooltip.growthStage") + ": " + AgriCore.getTranslator().translate("agricraft_tooltip.mature"));
            } else {
                information.add(AgriCore.getTranslator().translate("agricraft_tooltip.growthStage") + ": " + 100.0 * ((double)this.getGrowthStage() + 1.0) / (double)this.plant.getGrowthStages() + "%");
            }
            this.getStat().map(stat -> {
                if (stat.isAnalyzed()) {
                    stat.addStats(information);
                } else {
                    AgriCore.getTranslator().translate("agricraft_tooltip.analyzed");
                }
                return false;
            }).orElse(information.add(AgriCore.getTranslator().translate("agricraft_tooltip.analyzed")));
            information.add(AgriCore.getTranslator().translate(this.isFertile() ? "agricraft_tooltip.fertile" : "agricraft_tooltip.notFertile"));
        } else if (this.canWeed()) {
            information.add(AgriCore.getTranslator().translate("agricraft_tooltip.weeds"));
        } else {
            information.add(AgriCore.getTranslator().translate("agricraft_tooltip.empty"));
        }
    }
}

