/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.pad.AbstractBlockWaterPad;
import com.infinityraider.agricraft.blocks.pad.BlockWaterPadFull;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.blockstate.SidedConnection;
import com.infinityraider.infinitylib.render.block.RenderBlockBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderWaterPad
extends RenderBlockBase<AbstractBlockWaterPad> {
    private static final SidedConnection DEFAULT = new SidedConnection();

    public RenderWaterPad(AbstractBlockWaterPad block) {
        super((BlockBase)block, true);
    }

    public List<ResourceLocation> getAllTextures() {
        return Collections.emptyList();
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, AbstractBlockWaterPad block, EnumFacing side) {
        boolean full = block instanceof BlockWaterPadFull;
        SidedConnection connection = state instanceof IExtendedBlockState ? (SidedConnection)((IExtendedBlockState)state).getValue(AgriProperties.CONNECTIONS) : DEFAULT;
        this.renderBase(tessellator, connection, full);
        this.renderSide(tessellator, connection, full, EnumFacing.NORTH);
        this.renderSide(tessellator, connection, full, EnumFacing.EAST);
        this.renderSide(tessellator, connection, full, EnumFacing.SOUTH);
        this.renderSide(tessellator, connection, full, EnumFacing.WEST);
    }

    public void renderInventoryBlock(ITessellator tess, World world, IBlockState state, AbstractBlockWaterPad block, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        TextureAtlasSprite dirtIcon = BaseIcons.DIRT.getIcon();
        tess.drawScaledPrism(0.0f, 0.0f, 0.0f, 16.0f, 8.0f, 16.0f, dirtIcon);
        tess.drawScaledPrism(1.0f, 8.0f, 0.0f, 1.0f, 15.0f, 16.0f, dirtIcon);
        tess.drawScaledPrism(15.0f, 8.0f, 1.0f, 16.0f, 15.0f, 16.0f, dirtIcon);
        tess.drawScaledPrism(0.0f, 8.0f, 15.0f, 15.0f, 15.0f, 16.0f, dirtIcon);
        tess.drawScaledPrism(0.0f, 8.0f, 0.0f, 15.0f, 1.0f, 15.0f, dirtIcon);
        if (((ItemBlock)stack.func_77973_b()).field_150939_a instanceof BlockWaterPadFull) {
            TextureAtlasSprite textureAtlasSprite = BaseIcons.WATER_STILL.getIcon();
        }
    }

    private void renderBase(ITessellator tess, SidedConnection connection, boolean full) {
        TextureAtlasSprite waterIcon = BaseIcons.WATER_STILL.getIcon();
        tess.setColorRGBA(1, 1, 1, 1);
        if (this.shouldRenderCorner(connection, full, EnumFacing.WEST, EnumFacing.NORTH) || full) {
            // empty if block
        }
        if (this.shouldRenderCorner(connection, full, EnumFacing.NORTH, EnumFacing.EAST) || full) {
            // empty if block
        }
        if (this.shouldRenderCorner(connection, full, EnumFacing.EAST, EnumFacing.SOUTH) || full) {
            // empty if block
        }
        if (this.shouldRenderCorner(connection, full, EnumFacing.SOUTH, EnumFacing.WEST) || full) {
            // empty if block
        }
        if (full) {
            // empty if block
        }
    }

    private boolean shouldRenderCorner(SidedConnection connection, boolean full, EnumFacing dir1, EnumFacing dir2) {
        return connection.isConnected(dir1) && connection.isConnected(dir2);
    }

    private void renderSide(ITessellator tess, SidedConnection connection, boolean full, EnumFacing side) {
        int xLower = Math.max(0, 1 + 14 * side.func_82601_c());
        int xUpper = Math.min(16, 15 + 14 * side.func_82601_c());
        int zLower = Math.max(0, 1 + 14 * side.func_82599_e());
        int zUpper = Math.min(16, 15 + 14 * side.func_82599_e());
        if (!connection.isConnected(side) || full) {
            // empty if block
        }
    }

    public TextureAtlasSprite getIcon() {
        return null;
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }
}

