/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.irrigation.BlockWaterTank;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderBlockCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityTank;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.render.RenderUtilBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTank
extends RenderBlockCustomWood<BlockWaterTank, TileEntityTank> {
    static final float A = 0.001f;
    static final float B = 15.999f;

    public RenderTank(BlockWaterTank block) {
        super(block, new TileEntityTank(), true, true, true);
    }

    private void renderBottom(ITessellator tessellator, TextureAtlasSprite icon) {
        tessellator.drawScaledFace(0.001f, 0.001f, 15.999f, 15.999f, EnumFacing.DOWN, icon, 0.0f);
        tessellator.drawScaledFace(0.001f, 0.001f, 15.999f, 15.999f, EnumFacing.UP, icon, 1.0f);
    }

    private void renderSide(ITessellator tessellator, EnumFacing dir, TileEntityTank.Connection connection, TextureAtlasSprite icon) {
        if (connection == TileEntityTank.Connection.TANK) {
            return;
        }
        boolean xAxis = dir.func_176740_k() == EnumFacing.Axis.X;
        int index = xAxis ? dir.func_82601_c() : dir.func_82599_e();
        int min = index < 0 ? 0 : 14;
        int max = index < 0 ? 2 : 16;
        tessellator.drawScaledFace(xAxis ? (float)min : 0.0f, xAxis ? 0.0f : (float)min, xAxis ? (float)max : 16.0f, xAxis ? 16.0f : (float)max, EnumFacing.UP, icon, 16.0f);
        if (connection == TileEntityTank.Connection.NONE) {
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
        } else {
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 5.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 5.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(0.0f, 5.0f, 5.0f, 12.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 5.0f, 5.0f, 12.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(11.0f, 5.0f, 16.0f, 12.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(11.0f, 5.0f, 16.0f, 12.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(0.0f, 12.0f, 16.0f, 16.0f, dir, icon, index > 0 ? 16.0f : 0.0f);
            tessellator.drawScaledFace(0.0f, 12.0f, 16.0f, 16.0f, dir.func_176734_d(), icon, index > 0 ? 14.0f : 2.0f);
            tessellator.drawScaledFace(xAxis ? (float)min : 5.0f, xAxis ? 5.0f : (float)min, xAxis ? (float)max : 11.0f, xAxis ? 11.0f : (float)max, EnumFacing.UP, icon, 5.0f);
            tessellator.drawScaledFace(xAxis ? (float)min : 5.0f, xAxis ? 5.0f : (float)min, xAxis ? (float)max : 11.0f, xAxis ? 11.0f : (float)max, EnumFacing.DOWN, icon, 12.0f);
            EnumFacing left = xAxis ? EnumFacing.NORTH : EnumFacing.WEST;
            EnumFacing right = left.func_176734_d();
            tessellator.drawScaledFace((float)min, 5.0f, (float)max, 12.0f, left, icon, 11.0f);
            tessellator.drawScaledFace((float)min, 5.0f, (float)max, 12.0f, right, icon, 5.0f);
        }
    }

    @Override
    protected void renderWorldBlockWoodDynamic(ITessellator tessellator, World world, BlockPos pos, BlockWaterTank block, TileEntityTank tank, TextureAtlasSprite sprite) {
        if (tank.getYPosition() == 0) {
            float y = (float)tank.getFluidHeight() - 0.001f;
            int l = RenderUtilBase.getMixedBrightness((World)tank.func_145831_w(), (BlockPos)tank.func_174877_v(), (Block)Blocks.field_150355_j);
            tessellator.setBrightness(l);
            tessellator.setColorRGBA(tessellator.getRedValueInt(), tessellator.getRedValueInt(), tessellator.getBlueValueInt(), 100);
            TextureAtlasSprite waterIcon = BaseIcons.WATER_STILL.getIcon();
            tessellator.drawScaledFace(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.UP, waterIcon, y);
        }
    }

    @Override
    protected void renderWorldBlockWoodStatic(ITessellator tess, IExtendedBlockState state, BlockWaterTank block, EnumFacing side, TextureAtlasSprite sprite) {
        TileEntityTank.Connection north = (TileEntityTank.Connection)((Object)AgriProperties.TANK_NORTH.getValue((IBlockState)state));
        TileEntityTank.Connection east = (TileEntityTank.Connection)((Object)AgriProperties.TANK_EAST.getValue((IBlockState)state));
        TileEntityTank.Connection south = (TileEntityTank.Connection)((Object)AgriProperties.TANK_SOUTH.getValue((IBlockState)state));
        TileEntityTank.Connection west = (TileEntityTank.Connection)((Object)AgriProperties.TANK_WEST.getValue((IBlockState)state));
        TileEntityTank.Connection down = (TileEntityTank.Connection)((Object)AgriProperties.TANK_DOWN.getValue((IBlockState)state));
        this.renderSide(tess, EnumFacing.NORTH, north, sprite);
        this.renderSide(tess, EnumFacing.EAST, east, sprite);
        this.renderSide(tess, EnumFacing.SOUTH, south, sprite);
        this.renderSide(tess, EnumFacing.WEST, west, sprite);
        if (down != TileEntityTank.Connection.TANK) {
            this.renderBottom(tess, sprite);
        }
    }

    @Override
    protected void renderInventoryBlockWood(ITessellator tess, World world, IBlockState state, BlockWaterTank block, TileEntityTank tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type, TextureAtlasSprite sprite) {
        this.renderSide(tess, EnumFacing.NORTH, TileEntityTank.Connection.NONE, sprite);
        this.renderSide(tess, EnumFacing.EAST, TileEntityTank.Connection.NONE, sprite);
        this.renderSide(tess, EnumFacing.SOUTH, TileEntityTank.Connection.NONE, sprite);
        this.renderSide(tess, EnumFacing.WEST, TileEntityTank.Connection.NONE, sprite);
        this.renderBottom(tess, sprite);
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }
}

