/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.TypeHelper;
import com.google.common.collect.Maps;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.blocks.BlockCrop;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.render.block.RenderBlockWithTileBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderCrop
extends RenderBlockWithTileBase<BlockCrop, TileEntityCrop> {
    public static ResourceLocation TEXTURE = new ResourceLocation("agricraft:blocks/crop");
    private Map<VertexFormat, List<BakedQuad>[]> cropQuads = Maps.newIdentityHashMap();

    public RenderCrop(BlockCrop block) {
        super((BlockBase)block, (TileEntityBase)new TileEntityCrop(), false, true, false);
    }

    public List<ResourceLocation> getAllTextures() {
        return TypeHelper.asList(TEXTURE);
    }

    public void renderWorldBlockDynamic(ITessellator tessellator, World world, BlockPos pos, double x, double y, double z, BlockCrop block, TileEntityCrop tile, float partialTick, int destroyStage) {
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, BlockCrop block, EnumFacing side) {
        TextureAtlasSprite sprite = RenderCrop.getIcon((ResourceLocation)TEXTURE);
        this.renderBaseQuads(tessellator, side, sprite);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            IAgriPlant plant = (IAgriPlant)extendedState.getValue(AgriProperties.CROP_PLANT);
            int growthstage = (Integer)extendedState.getValue(AgriProperties.GROWTH_STAGE);
            if (((Boolean)extendedState.getValue(AgriProperties.CROSS_CROP)).booleanValue()) {
                tessellator.drawScaledPrism(0.0f, 10.0f, 2.0f, 16.0f, 11.0f, 3.0f, sprite);
                tessellator.drawScaledPrism(0.0f, 10.0f, 13.0f, 16.0f, 11.0f, 14.0f, sprite);
                tessellator.drawScaledPrism(2.0f, 10.0f, 0.0f, 3.0f, 11.0f, 16.0f, sprite);
                tessellator.drawScaledPrism(13.0f, 10.0f, 0.0f, 14.0f, 11.0f, 16.0f, sprite);
            }
            if (plant != null) {
                tessellator.addQuads(plant.getPlantQuads(extendedState, growthstage, side, (Function<ResourceLocation, TextureAtlasSprite>)tessellator));
            }
        }
    }

    private void renderBaseQuads(ITessellator tessellator, EnumFacing side, TextureAtlasSprite sprite) {
        int index = side == null ? EnumFacing.values().length : side.ordinal();
        boolean createQuads = false;
        if (!this.cropQuads.containsKey(tessellator.getVertexFormat())) {
            List[] lists = new List[EnumFacing.values().length + 1];
            this.cropQuads.put(tessellator.getVertexFormat(), lists);
            createQuads = true;
        } else if (this.cropQuads.get(tessellator.getVertexFormat())[index] == null) {
            createQuads = true;
        }
        if (createQuads) {
            tessellator.translate(0.0, -0.1875, 0.0);
            tessellator.drawScaledPrism(2.0f, 0.0f, 2.0f, 3.0f, 16.0f, 3.0f, sprite);
            tessellator.drawScaledPrism(13.0f, 0.0f, 2.0f, 14.0f, 16.0f, 3.0f, sprite);
            tessellator.drawScaledPrism(13.0f, 0.0f, 13.0f, 14.0f, 16.0f, 14.0f, sprite);
            tessellator.drawScaledPrism(2.0f, 0.0f, 13.0f, 3.0f, 16.0f, 14.0f, sprite);
            tessellator.translate(0.0, 0.1875, 0.0);
        } else {
            tessellator.addQuads(this.cropQuads.get(tessellator.getVertexFormat())[index]);
        }
    }

    public void renderInventoryBlock(ITessellator tessellator, World world, IBlockState state, BlockCrop block, TileEntityCrop tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
    }

    public TextureAtlasSprite getIcon() {
        return RenderCrop.getIcon((ResourceLocation)TEXTURE);
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }

    static {
        AgriCore.getConfig().addConfigurable(RenderCrop.class);
    }
}

