/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.blocks.irrigation.BlockWaterChannelValve;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderChannel;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannelValve;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.block.blockstate.SidedConnection;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderChannelValve
extends RenderChannel<BlockWaterChannelValve, TileEntityChannelValve> {
    public RenderChannelValve(BlockWaterChannelValve block) {
        super(block, new TileEntityChannelValve());
    }

    @Override
    public void renderInventoryBlockWood(ITessellator tessellator, World world, IBlockState state, BlockWaterChannelValve block, TileEntityChannelValve tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type, TextureAtlasSprite icon) {
        TextureAtlasSprite sepIcon = BaseIcons.IRON_BLOCK.getIcon();
        tessellator.drawScaledPrism(2.0f, 4.0f, 4.0f, 14.0f, 12.0f, 5.0f, icon);
        tessellator.drawScaledPrism(2.0f, 4.0f, 11.0f, 14.0f, 12.0f, 12.0f, icon);
        tessellator.drawScaledPrism(2.0f, 4.0f, 5.0f, 14.0f, 5.0f, 11.0f, icon);
        tessellator.drawScaledPrism(0.001f, 11.5f, 5.0f, 1.999f, 15.001f, 11.0f, sepIcon);
        tessellator.drawScaledPrism(0.001f, 0.999f, 5.0f, 1.999f, 5.5f, 11.0f, sepIcon);
        tessellator.drawScaledPrism(14.001f, 11.5f, 5.0f, 15.999f, 15.001f, 11.0f, sepIcon);
        tessellator.drawScaledPrism(14.001f, 0.999f, 5.0f, 15.999f, 5.5f, 11.0f, sepIcon);
        tessellator.drawScaledPrism(0.0f, 0.0f, 3.999f, 2.0f, 16.0f, 5.999f, icon);
        tessellator.translate(0.0, 0.0, 0.375);
        tessellator.drawScaledPrism(0.0f, 0.0f, 3.999f, 2.0f, 16.0f, 5.999f, icon);
        tessellator.translate(0.875, 0.0, 0.0);
        tessellator.drawScaledPrism(0.0f, 0.0f, 3.999f, 2.0f, 16.0f, 5.999f, icon);
        tessellator.translate(0.0, 0.0, -0.375);
        tessellator.drawScaledPrism(0.0f, 0.0f, 3.999f, 2.0f, 16.0f, 5.999f, icon);
        tessellator.translate(-0.875, 0.0, 0.0);
    }

    @Override
    protected void renderSide(ITessellator tessellator, IBlockState state, EnumFacing dir, boolean connect, TextureAtlasSprite matIcon) {
        super.renderSide(tessellator, state, dir, connect, matIcon);
        if (state instanceof IExtendedBlockState) {
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            SidedConnection levers = (SidedConnection)extendedState.getValue(AgriProperties.CONNECTIONS);
            if (levers != null && levers.isConnected(dir)) {
                this.renderConnector(tessellator, dir, matIcon);
            }
            if (connect) {
                this.renderSeparator(tessellator, extendedState, dir, matIcon, BaseIcons.IRON_BLOCK.getIcon());
            }
        }
    }

    private void renderConnector(ITessellator tessellator, EnumFacing dir, TextureAtlasSprite matIcon) {
        switch (dir) {
            case EAST: {
                tessellator.drawScaledPrism(12.0f, 4.0f, 5.0f, 16.0f, 12.0f, 11.0f, matIcon);
                break;
            }
            case WEST: {
                tessellator.drawScaledPrism(0.0f, 4.0f, 5.0f, 4.0f, 12.0f, 11.0f, matIcon);
                break;
            }
            case NORTH: {
                tessellator.drawScaledPrism(5.0f, 4.0f, 0.0f, 11.0f, 12.0f, 4.0f, matIcon);
                break;
            }
            case SOUTH: {
                tessellator.drawScaledPrism(5.0f, 4.0f, 12.0f, 11.0f, 12.0f, 16.0f, matIcon);
            }
        }
    }

    private void renderSeparator(ITessellator tessellator, IExtendedBlockState state, EnumFacing dir, TextureAtlasSprite matIcon, TextureAtlasSprite sepIcon) {
        boolean powered = (Boolean)AgriProperties.POWERED.getValue((IBlockState)state);
        switch (dir) {
            case EAST: {
                tessellator.drawScaledPrism(14.0f, 0.0f, 3.0f, 16.0f, 16.0f, 6.0f, matIcon);
                tessellator.drawScaledPrism(14.0f, 0.0f, 10.0f, 16.0f, 16.0f, 13.0f, matIcon);
                if (powered) {
                    tessellator.drawScaledPrism(14.0f, 5.0f, 6.0f, 16.0f, 12.0f, 10.0f, sepIcon);
                    break;
                }
                tessellator.drawScaledPrism(14.0f, 1.0f, 6.0f, 16.0f, 5.001f, 10.0f, sepIcon);
                tessellator.drawScaledPrism(14.0f, 12.0f, 6.0f, 16.0f, 15.0f, 10.0f, sepIcon);
                break;
            }
            case WEST: {
                tessellator.drawScaledPrism(0.0f, 0.0f, 3.0f, 2.0f, 16.0f, 6.0f, matIcon);
                tessellator.drawScaledPrism(0.0f, 0.0f, 10.0f, 2.0f, 16.0f, 13.0f, matIcon);
                if (powered) {
                    tessellator.drawScaledPrism(0.0f, 5.0f, 6.0f, 2.0f, 12.0f, 10.0f, sepIcon);
                    break;
                }
                tessellator.drawScaledPrism(0.0f, 1.0f, 6.0f, 2.0f, 5.001f, 10.0f, sepIcon);
                tessellator.drawScaledPrism(0.0f, 12.0f, 6.0f, 2.0f, 15.0f, 10.0f, sepIcon);
                break;
            }
            case NORTH: {
                tessellator.drawScaledPrism(3.0f, 0.0f, 0.0f, 6.0f, 16.0f, 2.0f, matIcon);
                tessellator.drawScaledPrism(10.0f, 0.0f, 0.0f, 13.0f, 16.0f, 2.0f, matIcon);
                if (powered) {
                    tessellator.drawScaledPrism(6.0f, 5.0f, 0.0f, 10.0f, 12.0f, 2.0f, sepIcon);
                    break;
                }
                tessellator.drawScaledPrism(6.0f, 1.0f, 0.0f, 10.0f, 5.001f, 2.0f, sepIcon);
                tessellator.drawScaledPrism(6.0f, 12.0f, 0.0f, 10.0f, 15.0f, 2.0f, sepIcon);
                break;
            }
            case SOUTH: {
                tessellator.drawScaledPrism(3.0f, 0.0f, 14.0f, 6.0f, 16.0f, 16.0f, matIcon);
                tessellator.drawScaledPrism(10.0f, 0.0f, 14.0f, 13.0f, 16.0f, 16.0f, matIcon);
                if (powered) {
                    tessellator.drawScaledPrism(6.0f, 5.0f, 14.0f, 10.0f, 12.0f, 16.0f, sepIcon);
                    break;
                }
                tessellator.drawScaledPrism(6.0f, 1.0f, 14.0f, 10.0f, 5.001f, 16.0f, sepIcon);
                tessellator.drawScaledPrism(6.0f, 12.0f, 14.0f, 10.0f, 15.0f, 16.0f, sepIcon);
            }
        }
    }
}

