/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.apiimpl.PlantRegistry;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemJournal
extends ItemBase
implements IAgriJournalItem,
IItemWithModel {
    public ItemJournal() {
        super("journal");
        this.func_77625_d(1);
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77946_l();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K) {
            player.openGui((Object)AgriCraft.instance, 2, world, player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        list.add(AgriCore.getTranslator().translate("agricraft_tooltip.discoveredSeeds") + ": " + this.getDiscoveredSeedIds(stack).size());
    }

    private List<String> getDiscoveredSeedIds(ItemStack journal) {
        if (journal == null) {
            return new ArrayList<String>();
        }
        if (!journal.func_77942_o()) {
            journal.func_77982_d(new NBTTagCompound());
            return new ArrayList<String>();
        }
        NBTTagCompound tag = journal.func_77978_p();
        String discovered = tag.func_74779_i("agri_discovered");
        if (discovered.isEmpty()) {
            return new ArrayList<String>();
        }
        return Arrays.asList(discovered.split(";"));
    }

    @Override
    public void addEntry(ItemStack journal, IAgriPlant plant) {
        List<String> seeds;
        if (journal != null && journal.func_77973_b() != null && plant != null && !(seeds = this.getDiscoveredSeedIds(journal)).contains(plant.getId())) {
            NBTTagCompound tag = journal.func_77978_p();
            String old = tag.func_74779_i("agri_discovered");
            tag.func_74778_a("agri_discovered", old + plant.getId() + ";");
            journal.func_77982_d(tag);
        }
    }

    @Override
    public boolean isSeedDiscovered(ItemStack journal, IAgriPlant plant) {
        return journal != null && plant != null && this.getDiscoveredSeedIds(journal).contains(plant.getId());
    }

    @Override
    public List<IAgriPlant> getDiscoveredSeeds(ItemStack journal) {
        ArrayList<IAgriPlant> list = new ArrayList<IAgriPlant>();
        if (journal != null && journal.func_77942_o()) {
            for (String id : this.getDiscoveredSeedIds(journal)) {
                IAgriPlant plant = PlantRegistry.getInstance().getPlant(id);
                if (plant == null) continue;
                list.add(plant);
            }
        }
        return list;
    }
}

