/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.config.AgriConfigCategory;
import com.agricraft.agricore.config.AgriConfigurable;
import com.agricraft.agricore.core.AgriCore;
import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.api.items.IAgriRakeItem;
import com.infinityraider.agricraft.api.misc.IAgriWeedable;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.utility.WeightedRandom;
import com.infinityraider.infinitylib.item.IItemWithModel;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHandRake
extends ItemBase
implements IAgriRakeItem,
IItemWithModel {
    @AgriConfigurable(category=AgriConfigCategory.TOOLS, key="Enable Hand Rake", comment="Set to false to disable the Hand Rake.")
    public static boolean enableHandRake = true;
    private static final int WOOD_VARIANT_META = 0;
    private static final int IRON_VARIANT_META = 1;
    private static final int[] dropChance = new int[]{10, 25};

    public ItemHandRake() {
        super("hand_rake");
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IAgriWeedable) {
            IAgriWeedable tile = (IAgriWeedable)te;
            if (tile.canWeed()) {
                ItemStack drop;
                tile.clearWeed();
                if (AgriCraftConfig.rakingDrops && world.field_73012_v.nextInt(100) < dropChance[stack.func_77952_i() % dropChance.length] && (drop = ItemDropRegistry.instance().getDrop(world.field_73012_v)) != null && drop.func_77973_b() != null) {
                    float f = 0.7f;
                    double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
                    entityitem.func_174867_a(10);
                    world.func_72838_d((Entity)entityitem);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        return EnumActionResult.PASS;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    public String func_77667_c(ItemStack itemStack) {
        String base = super.func_77667_c(itemStack);
        switch (itemStack.func_77952_i()) {
            case 0: {
                return base + ".wood";
            }
            case 1: {
                return base + ".iron";
            }
        }
        throw new IllegalArgumentException("Unsupported meta value of " + itemStack.func_77952_i() + " for ItemHandRake.");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean flag) {
        list.add(AgriCore.getTranslator().translate("agricraft_tooltip.handRake"));
    }

    public boolean isEnabled() {
        return enableHandRake;
    }

    public List<Tuple<Integer, ModelResourceLocation>> getModelDefinitions() {
        return ImmutableList.of((Object)new Tuple((Object)0, (Object)new ModelResourceLocation(this.getRegistryName() + "")), (Object)new Tuple((Object)1, (Object)new ModelResourceLocation(this.getRegistryName() + "_iron")));
    }

    public static final class ItemDropRegistry {
        private static ItemDropRegistry INSTANCE;
        private final WeightedRandom<ItemStack> registry = new WeightedRandom();

        private ItemDropRegistry() {
        }

        public static ItemDropRegistry instance() {
            if (INSTANCE == null) {
                INSTANCE = new ItemDropRegistry();
            }
            return INSTANCE;
        }

        public void registerDrop(ItemStack stack, int weight) {
            this.registry.addEntry(stack, weight);
        }

        public void removeDrop(ItemStack stack) {
            this.registry.removeEntry(stack);
        }

        public ItemStack getDrop(Random rand) {
            return this.registry.getRandomEntry(rand).func_77946_l();
        }

        public int getWeight(ItemStack stack) {
            return this.registry.getWeight(stack);
        }

        static {
            ItemDropRegistry.instance().registerDrop(new ItemStack((Block)Blocks.field_150329_H, 1, 1), 20);
            ItemDropRegistry.instance().registerDrop(new ItemStack((Block)Blocks.field_150329_H, 1, 2), 10);
            ItemDropRegistry.instance().registerDrop(new ItemStack((Block)Blocks.field_150398_cm, 1, 2), 10);
        }
    }
}

