/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.TypeHelper;
import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.utility.StackHelper;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.render.item.ItemModelTexture;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemClipping
extends ItemBase
implements IAutoRenderedItem {
    public ItemClipping() {
        super("clipping");
        this.func_77637_a(null);
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity te = world.func_175625_s(pos);
        if (world.field_72995_K || !StackHelper.hasTag(stack) || !(te instanceof IAgriCrop)) {
            return EnumActionResult.PASS;
        }
        IAgriCrop crop = (IAgriCrop)te;
        AgriSeed seed = SeedRegistry.getInstance().valueOf(stack).orElse(null);
        if (!crop.acceptsSeed(seed) || seed == null) {
            return EnumActionResult.FAIL;
        }
        --stack.field_77994_a;
        if (world.field_73012_v.nextInt(10) <= seed.getStat().getStrength()) {
            crop.setSeed(seed);
        }
        return EnumActionResult.SUCCESS;
    }

    public String func_77653_i(ItemStack stack) {
        String text = AgriCore.getTranslator().translate("item.agricraft:clipping.name");
        Optional<AgriSeed> seed = SeedRegistry.getInstance().valueOf(stack);
        return seed.map(s -> s.getPlant().getPlantName()).orElse("Generic") + " " + text;
    }

    public static ItemStack getClipping(AgriSeed seed, int amount) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("agri_seed", seed.getPlant().getId());
        seed.getStat().writeToNBT(tag);
        ItemStack stack = new ItemStack((Item)AgriItems.getInstance().AGRI_CLIPPING);
        stack.func_77982_d(tag);
        return stack;
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelId(ItemStack stack) {
        Optional<AgriSeed> seed = SeedRegistry.getInstance().valueOf(stack);
        return seed.map(s -> s.getPlant().getId()).orElse("");
    }

    @SideOnly(value=Side.CLIENT)
    public String getBaseTexture(ItemStack stack) {
        return "agricraft:items/clipping";
    }

    @SideOnly(value=Side.CLIENT)
    public List<ItemModelTexture> getOverlayTextures(ItemStack stack) {
        AgriSeed seed = SeedRegistry.getInstance().valueOf(stack).orElse(null);
        ResourceLocation tex = seed == null ? new ResourceLocation("agricraft:items/debugger") : seed.getPlant().getPrimaryPlantTexture(7);
        return TypeHelper.asList(new ItemModelTexture(tex, 4.0f, 4.0f, 12.0f, 12.0f, 0.0f, 0.0f, 16.0f, 16.0f));
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getAllTextures() {
        return TypeHelper.asList(new ResourceLocation("agricraft:items/clipping"));
    }
}

