/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.items;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.apiimpl.PlantRegistry;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.apiimpl.StatRegistry;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.items.tabs.AgriTabs;
import com.infinityraider.agricraft.utility.NBTHelper;
import com.infinityraider.infinitylib.item.IAutoRenderedItem;
import com.infinityraider.infinitylib.item.ItemBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAgriSeed
extends ItemBase
implements IAgriAdapter<AgriSeed>,
IAutoRenderedItem {
    public ItemAgriSeed() {
        super("agri_seed");
        this.func_77637_a(AgriTabs.TAB_AGRICRAFT_SEED);
    }

    public void func_150895_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        PlantStats baseStat = new PlantStats();
        for (IAgriPlant plant : PlantRegistry.getInstance().getPlants()) {
            if (!plant.getSeedItems().stream().anyMatch(s -> s.isItemEqual((Item)this))) continue;
            ItemStack stack = new ItemStack(item);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("agri_seed", plant.getId());
            baseStat.writeToNBT(tag);
            stack.func_77982_d(tag);
            list.add(stack);
        }
    }

    public boolean func_77614_k() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        Optional<AgriSeed> seed = SeedRegistry.getInstance().valueOf(stack);
        return seed.map(s -> s.getPlant().getSeedName()).orElse("Generic Seeds");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.func_180495_p(pos).func_177230_c() == AgriBlocks.getInstance().CROP) {
            AgriCore.getLogger("AgriCraft").debug("Trying to plant seed " + stack.func_77973_b().func_77658_a() + " on crops", new Object[0]);
            if (!player.func_184812_l_()) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public List<String> getIgnoredNBT() {
        List tags = super.getIgnoredNBT();
        tags.add("agri_analyzed");
        tags.add("agri_growth");
        tags.add("agri_gain");
        tags.add("agri_strength");
        return tags;
    }

    @Override
    public boolean accepts(Object obj) {
        NBTTagCompound tag = NBTHelper.asTag(obj);
        return tag != null && tag.func_74764_b("agri_seed") && StatRegistry.getInstance().hasAdapter(tag);
    }

    @Override
    public Optional<AgriSeed> valueOf(Object obj) {
        NBTTagCompound tag = NBTHelper.asTag(obj);
        if (tag == null) {
            return Optional.empty();
        }
        IAgriPlant plant = PlantRegistry.getInstance().getPlant(tag.func_74779_i("agri_seed"));
        IAgriStat stat = StatRegistry.getInstance().valueOf(tag).get();
        if (plant != null && stat != null) {
            return Optional.of(new AgriSeed(plant, stat));
        }
        return Optional.empty();
    }

    @SideOnly(value=Side.CLIENT)
    public String getModelId(ItemStack stack) {
        Optional<AgriSeed> seed = SeedRegistry.getInstance().valueOf(stack);
        return seed.map(s -> s.getPlant().getId()).orElse("");
    }

    @SideOnly(value=Side.CLIENT)
    public String getBaseTexture(ItemStack stack) {
        Optional<AgriSeed> seed = SeedRegistry.getInstance().valueOf(stack);
        return seed.map(s -> s.getPlant().getSeedTexture().toString()).orElse("agricraft:items/seed_unknown");
    }

    @SideOnly(value=Side.CLIENT)
    public List<ResourceLocation> getAllTextures() {
        Collection<IAgriPlant> plants = PlantRegistry.getInstance().getPlants();
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>(plants.size());
        textures.add(new ResourceLocation("agricraft:items/seed_unknown"));
        for (IAgriPlant p : PlantRegistry.getInstance().getPlants()) {
            textures.add(p.getSeedTexture());
        }
        return textures;
    }
}

