/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.init;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.ReflectionHelper;
import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.crafting.RecipeJournal;
import com.infinityraider.agricraft.crafting.RecipeShapelessCustomWood;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.items.blocks.ItemBlockCustomWood;
import com.infinityraider.agricraft.reference.AgriNuggetType;
import com.infinityraider.agricraft.utility.OreDictHelper;
import com.infinityraider.infinitylib.utility.RegisterHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AgriRecipes {
    public static final ItemStack REFERENCE = new ItemStack(Blocks.field_150344_f, 1);
    private static final List<ItemStack> woodList = new ArrayList<ItemStack>();

    public static void init() {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().CROPS, AgriCraftConfig.cropsPerCraft), new Object[]{"ss", "ss", Character.valueOf('s'), "stickWood"}));
        if (AgriCraftConfig.cropsPerCraft == 3) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151055_y, 6 / AgriCraftConfig.cropsPerCraft), (Object[])new Object[]{new ItemStack((Item)AgriItems.getInstance().CROPS), new ItemStack((Item)AgriItems.getInstance().CROPS)});
        } else {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151055_y, 4 / AgriCraftConfig.cropsPerCraft), (Object[])new Object[]{new ItemStack((Item)AgriItems.getInstance().CROPS)});
        }
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)AgriBlocks.getInstance().SEED_ANALYZER, 1), new Object[]{"sgs", " bs", "pwp", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "paneGlass", Character.valueOf('b'), Blocks.field_150333_U, Character.valueOf('p'), "plankWood", Character.valueOf('w'), "slabWood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().JOURNAL, 1), new Object[]{"csc", "sbs", "csc", Character.valueOf('c'), AgriItems.getInstance().CROPS, Character.valueOf('s'), Items.field_151014_N, Character.valueOf('b'), Items.field_151122_aG}));
        RecipeSorter.register((String)"recipe.copy_journal", RecipeJournal.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        GameRegistry.addRecipe((IRecipe)new RecipeJournal());
        if (AgriItems.getInstance().TROWEL.isEnabled()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().TROWEL, 1, 0), new Object[]{"  s", "ii ", Character.valueOf('s'), "stickWood", Character.valueOf('i'), "ingotIron"}));
        }
        if (AgriItems.getInstance().MAGNIFYING_GLASS.isEnabled()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().MAGNIFYING_GLASS, 1, 0), new Object[]{"sgs", " s ", " s ", Character.valueOf('s'), "stickWood", Character.valueOf('g'), "paneGlass"}));
        }
        if (AgriItems.getInstance().HAND_RAKE.isEnabled()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 0), new Object[]{"fs", Character.valueOf('f'), Blocks.field_180407_aO, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 0), new Object[]{"fs", Character.valueOf('f'), Blocks.field_180404_aQ, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 0), new Object[]{"fs", Character.valueOf('f'), Blocks.field_180408_aP, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 0), new Object[]{"fs", Character.valueOf('f'), Blocks.field_180405_aT, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 0), new Object[]{"fs", Character.valueOf('f'), Blocks.field_180403_aR, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 0), new Object[]{"fs", Character.valueOf('f'), Blocks.field_180406_aS, Character.valueOf('s'), "stickWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().HAND_RAKE, 1, 1), new Object[]{"fs", Character.valueOf('f'), Blocks.field_150411_aY, Character.valueOf('s'), "stickWood"}));
        }
        if (AgriItems.getInstance().CLIPPER.isEnabled()) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)AgriItems.getInstance().CLIPPER, 1, 0), new Object[]{" i ", "scn", " s ", Character.valueOf('i'), "ingotIron", Character.valueOf('s'), "stickWood", Character.valueOf('c'), new ItemStack((Item)Items.field_151097_aZ)}));
        }
        AgriRecipes.registerCustomWoodRecipes();
        if (AgriCraftConfig.enableIrrigation) {
            RegisterHelper.removeRecipe((ItemStack)new ItemStack(Items.field_151054_z));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_151054_z, 4), new Object[]{"w w", " w ", Character.valueOf('w'), "slabWood"}));
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Block)AgriBlocks.getInstance().SPRINKLER, 1), new Object[]{" w ", " i ", "bcb", Character.valueOf('w'), "plankWood", Character.valueOf('i'), "ingotIron", Character.valueOf('b'), Blocks.field_150411_aY, Character.valueOf('c'), Items.field_151133_ar}));
        }
        for (AgriNuggetType type : AgriNuggetType.values()) {
            ItemStack nugget = new ItemStack((Item)AgriItems.getInstance().AGRI_NUGGET, 9, type.ordinal());
            ItemStack ingot = OreDictHelper.getIngot(type.ingot);
            AgriCore.getLogger("AgriCraft").debug("Registering Nugget: {0} For: {1}", type.nugget, type.ingot);
            if (ingot == null) continue;
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(ingot, new Object[]{"nnn", "nnn", "nnn", Character.valueOf('n'), type.nugget}));
            GameRegistry.addRecipe((IRecipe)new ShapelessOreRecipe(nugget, new Object[]{type.ingot}));
        }
        AgriCore.getLogger("AgriCraft").debug("Recipes Registered", new Object[0]);
    }

    private static void registerCustomWoodRecipes() {
        AgriRecipes.initWoodList();
        RecipeSorter.register((String)"recipe.custom_wood_shapeless", RecipeShapelessCustomWood.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        if (AgriCraftConfig.enableIrrigation) {
            ItemStack channel = new ItemStack((Block)AgriBlocks.getInstance().CHANNEL, 1);
            ItemStack channelFull = new ItemStack((Block)AgriBlocks.getInstance().CHANNEL_FULL, 1);
            AgriRecipes.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().TANK, 1, true, "w w", "w w", "www", Character.valueOf('w'), REFERENCE);
            AgriRecipes.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().CHANNEL, 6, true, "w w", " w ", Character.valueOf('w'), REFERENCE);
            AgriRecipes.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().CHANNEL_FULL, 1, false, channel, channel, channel, channel);
            AgriRecipes.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().CHANNEL, 4, false, channelFull);
            AgriRecipes.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().CHANNEL_VALVE, 1, false, new ItemStack(Items.field_151042_j, 1), new ItemStack(Blocks.field_150442_at, 1), channel);
        }
        if (AgriCraftConfig.enableGrates) {
            AgriRecipes.registerCustomWoodRecipe((Block)AgriBlocks.getInstance().GRATE, 8, true, "w w", " w ", "w w", Character.valueOf('w'), REFERENCE);
        }
    }

    private static void initWoodList() {
        if (woodList.isEmpty()) {
            ReflectionHelper.forEachValueIn(AgriBlocks.getInstance(), BlockCustomWood.class, b -> {
                AgriCore.getLogger("AgriCraft").debug("Block: {0} Item: {1}", b, Item.func_150898_a((Block)b));
                Optional.ofNullable(Item.func_150898_a((Block)b)).filter(i -> i instanceof ItemBlockCustomWood).map(i -> (ItemBlockCustomWood)((Object)((Object)i))).ifPresent(i -> i.getSubItems(woodList));
            });
        }
    }

    public static void registerCustomWoodRecipe(Block block, int stackSize, boolean shaped, Object ... params) {
        for (ItemStack stack : woodList) {
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("agri_material") || !stack.func_77978_p().func_74764_b("agri_material_meta")) continue;
            NBTTagCompound materialTag = stack.func_77978_p();
            ItemStack plank = new ItemStack(Block.func_149684_b((String)materialTag.func_74779_i("agri_material")), 1, materialTag.func_74762_e("agri_material_meta"));
            Object[] ingredients = Arrays.copyOf(params, params.length);
            for (int i = 0; i < ingredients.length; ++i) {
                if (ingredients[i] instanceof ItemStack && ((ItemStack)ingredients[i]).func_77969_a(REFERENCE)) {
                    ingredients[i] = plank;
                }
                if (!(ingredients[i] instanceof ItemStack) || ingredients[i] == null || !(((ItemStack)ingredients[i]).func_77973_b() instanceof ItemBlockCustomWood)) continue;
                ((ItemStack)ingredients[i]).func_77982_d(materialTag);
            }
            ItemStack result = new ItemStack(block, stackSize);
            result.func_77982_d(materialTag);
            if (shaped) {
                GameRegistry.addShapedRecipe((ItemStack)result, (Object[])ingredients);
                continue;
            }
            AgriRecipes.addShapelessCustomWoodRecipe(result, ingredients);
        }
    }

    public static void registerCustomWoodRecipe(IRecipe recipe) {
        if (recipe instanceof ShapedRecipes) {
            ShapedRecipes shapedRecipe = (ShapedRecipes)recipe;
            AgriRecipes.registerCustomWoodRecipe(((ItemBlock)shapedRecipe.func_77571_b().func_77973_b()).field_150939_a, shapedRecipe.func_77571_b().field_77994_a, true, shapedRecipe.field_77574_d);
        } else if (recipe instanceof ShapelessRecipes) {
            ShapelessRecipes shapelessRecipe = (ShapelessRecipes)recipe;
            AgriRecipes.registerCustomWoodRecipe(((ItemBlock)shapelessRecipe.func_77571_b().func_77973_b()).field_150939_a, shapelessRecipe.func_77571_b().field_77994_a, false, shapelessRecipe.field_77579_b.toArray(new ItemStack[shapelessRecipe.field_77579_b.size()]));
        }
    }

    private static void addShapelessCustomWoodRecipe(ItemStack output, Object ... params) {
        ArrayList<ItemStack> recipeItemsCopy = new ArrayList<ItemStack>();
        for (Object recipeItem : params) {
            if (recipeItem instanceof ItemStack) {
                recipeItemsCopy.add(((ItemStack)recipeItem).func_77946_l());
                continue;
            }
            if (recipeItem instanceof Item) {
                recipeItemsCopy.add(new ItemStack((Item)recipeItem));
                continue;
            }
            if (!(recipeItem instanceof Block)) {
                throw new RuntimeException("Invalid shapeless recipe!");
            }
            recipeItemsCopy.add(new ItemStack((Block)recipeItem));
        }
        RecipeShapelessCustomWood recipe = new RecipeShapelessCustomWood(output, recipeItemsCopy);
        GameRegistry.addRecipe((IRecipe)recipe);
    }
}

