/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.blocks.decoration.BlockGrate;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.farming.growthrequirement.GrowthRequirementHandler;
import com.infinityraider.agricraft.init.AgriBlocks;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class PlayerInteractEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void vanillaSeedPlanting(PlayerInteractEvent.RightClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184607_cu();
        if (stack != null && stack.field_77994_a > 0 && stack.func_77973_b() != null && stack.func_77973_b() instanceof IPlantable && GrowthRequirementHandler.isSoilValid((IBlockAccess)event.getWorld(), event.getPos())) {
            if (AgriCraftConfig.disableVanillaFarming && !SeedRegistry.getInstance().hasAdapter(stack)) {
                this.denyEvent(event, false);
            } else if (stack.func_77942_o()) {
                NBTTagCompound tag = stack.func_77978_p().func_74737_b();
                this.denyEvent(event, false);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void waterPadCreation(PlayerInteractEvent.RightClickBlock event) {
        IBlockState state = event.getWorld().func_180495_p(event.getPos());
        Block block = state.func_177230_c();
        if (block != Blocks.field_150458_ak) {
            return;
        }
        boolean flag = false;
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = player.func_184607_cu();
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemSpade) {
            flag = true;
        }
        if (flag) {
            if (event.getWorld().field_72995_K) {
                this.denyEvent(event, true);
            }
            event.getWorld().func_180501_a(event.getPos(), AgriBlocks.getInstance().WATER_PAD.func_176223_P(), 3);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77972_a(1, (EntityLivingBase)player);
                event.setResult(Event.Result.ALLOW);
            }
            SoundType sound = block.func_185467_w();
            event.getWorld().func_184148_a(null, (double)((float)event.getPos().func_177958_n() + 0.5f), (double)((float)event.getPos().func_177956_o() + 0.5f), (double)((float)event.getPos().func_177952_p() + 0.5f), sound.func_185845_c(), SoundCategory.BLOCKS, (sound.func_185843_a() + 1.0f) / 2.0f, sound.func_185847_b() * 0.8f);
            this.denyEvent(event, false);
        }
    }

    @SubscribeEvent
    public void applyVinesToGrate(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getEntityPlayer().func_184607_cu();
        if (stack == null || stack.func_77973_b() == null || stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150395_bd)) {
            return;
        }
        Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
        if (!(block instanceof BlockGrate)) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            this.denyEvent(event, true);
        } else {
            block.func_180639_a(event.getWorld(), event.getPos(), event.getWorld().func_180495_p(event.getPos()), event.getEntityPlayer(), EnumHand.MAIN_HAND, stack, event.getFace(), 0.0f, 0.0f, 0.0f);
        }
    }

    @SubscribeEvent
    public void denyBonemeal(PlayerInteractEvent.RightClickBlock event) {
        TileEntity te;
        if (!event.getEntityPlayer().func_70093_af()) {
            return;
        }
        ItemStack heldItem = event.getEntityPlayer().func_184607_cu();
        if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 15 && (te = event.getWorld().func_175625_s(event.getPos())) != null && te instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)te;
            this.denyEvent(event, false);
        }
    }

    private void denyEvent(PlayerInteractEvent.RightClickBlock event, boolean sendToServer) {
        event.setResult(Event.Result.DENY);
        event.setUseItem(Event.Result.DENY);
        event.setUseBlock(Event.Result.DENY);
        if (!sendToServer || event.getWorld().field_72995_K) {
            // empty if block
        }
        event.setCanceled(true);
    }
}

