/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.log.AgriLogger;
import com.agricraft.agricore.plant.AgriMutation;
import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.plant.AgriSoil;
import com.infinityraider.agricraft.network.json.MessageSyncMutationJson;
import com.infinityraider.agricraft.network.json.MessageSyncPlantJson;
import com.infinityraider.agricraft.network.json.MessageSyncSoilJson;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PlayerConnectToServerHandler {
    private static final AgriLogger log = AgriCore.getLogger("Agri-Net");

    @SubscribeEvent
    public void onConnect(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        this.syncSoils(player);
        this.syncPlants(player);
        this.syncMutations(player);
    }

    private void syncSoils(EntityPlayerMP player) {
        log.debug("Sending soils to player: " + player.getDisplayNameString(), new Object[0]);
        int count = AgriCore.getSoils().getAll().size();
        Iterator<AgriSoil> it = AgriCore.getSoils().getAll().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriSoil soil = it.next();
            log.debug("Sending Soil: {0} ({1} of {2})", soil, i + 1, count);
            new MessageSyncSoilJson(soil, i, count).sendTo(player);
            ++i;
        }
        log.debug("Finished sending soils to player: " + player.getDisplayNameString(), new Object[0]);
    }

    private void syncPlants(EntityPlayerMP player) {
        log.debug("Sending plants to player: " + player.getDisplayNameString(), new Object[0]);
        int count = AgriCore.getPlants().getAll().size();
        Iterator<AgriPlant> it = AgriCore.getPlants().getAll().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriPlant plant = it.next();
            log.debug("Sending plant: {0} ({1} of {2})", plant.getPlantName(), i + 1, count);
            new MessageSyncPlantJson(plant, i, count).sendTo(player);
            ++i;
        }
        log.debug("Finished sending plants to player: " + player.getDisplayNameString(), new Object[0]);
    }

    private void syncMutations(EntityPlayerMP player) {
        log.debug("Sending mutations to player: " + player.getDisplayNameString(), new Object[0]);
        int count = AgriCore.getMutations().getAll().size();
        Iterator<AgriMutation> it = AgriCore.getMutations().getAll().iterator();
        int i = 0;
        while (it.hasNext()) {
            AgriMutation mutation = it.next();
            log.debug("Sending mutation: ({0} of {1})", i + 1, count);
            new MessageSyncMutationJson(mutation, i, count).sendTo(player);
            ++i;
        }
        log.debug("Finished sending mutations to player: " + player.getDisplayNameString(), new Object[0]);
    }
}

