/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.handler;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.items.IAgriClipperItem;
import com.infinityraider.agricraft.api.items.IAgriTrowelItem;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.utility.StackHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ItemToolTipHandler {
    private static final ItemToolTipHandler INSTANCE = new ItemToolTipHandler();

    public static ItemToolTipHandler getInstance() {
        return INSTANCE;
    }

    private ItemToolTipHandler() {
    }

    @SubscribeEvent
    public void addSeedStatsTooltip(ItemTooltipEvent event) {
        AgriSeed seed;
        ItemStack stack = event.getItemStack();
        if (stack != null && (seed = (AgriSeed)SeedRegistry.getInstance().valueOf(stack).orElse(null)) != null) {
            if (seed.getStat().isAnalyzed()) {
                seed.getStat().addStats(event.getToolTip());
            } else {
                event.getToolTip().add(" " + AgriCore.getTranslator().translate("agricraft_tooltip.unidentified"));
            }
        }
    }

    @SubscribeEvent
    public void addTrowelTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b() instanceof IAgriTrowelItem) {
            AgriSeed seed = SeedRegistry.getInstance().valueOf(event.getItemStack()).orElse(null);
            if (seed != null) {
                event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.seed") + ": " + seed.getPlant().getSeedName());
            } else {
                event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.trowel"));
            }
        }
    }

    @SubscribeEvent
    public void addClipperTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (StackHelper.isValid(stack, IAgriClipperItem.class)) {
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper1"));
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper2"));
            event.getToolTip().add(AgriCore.getTranslator().translate("agricraft_tooltip.clipper3"));
        }
    }
}

