/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui.journal;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.apiimpl.MutationRegistry;
import com.infinityraider.agricraft.gui.component.BasicComponents;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import com.infinityraider.agricraft.gui.journal.GuiJournal;
import com.infinityraider.agricraft.gui.journal.JournalPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class JournalPageSeed
implements JournalPage {
    public static final int MUTATION_ROW_HEIGHT = 20;
    private static final ResourceLocation MUTATION_TEMPLATE = new ResourceLocation("agricraft", "textures/gui/journal/GuiJournalMutationTemplate.png");
    private static final ResourceLocation QUESTION_MARK = new ResourceLocation("agricraft", "textures/gui/journal/GuiJournalQuestionMark.png");
    private static final ResourceLocation BRIGHTNESS_BAR = new ResourceLocation("agricraft", "textures/gui/journal/GuiJournalBrightnessBar.png");
    private static final ResourceLocation BRIGHTNESS_FRAME = new ResourceLocation("agricraft", "textures/gui/journal/GuiJournalBrightnessFrame.png");
    private final GuiJournal journal;
    private final int page;
    private final IAgriPlant plant;
    private final List<IAgriPlant> discoveredSeeds;
    private final List<GuiComponent> fruits = new ArrayList<GuiComponent>();
    private final List<GuiComponent> seeds = new ArrayList<GuiComponent>();

    public JournalPageSeed(GuiJournal journal, List<IAgriPlant> discoveredSeeds, int page) {
        this.journal = journal;
        this.discoveredSeeds = discoveredSeeds;
        this.page = page;
        this.plant = discoveredSeeds.get(page);
        this.addFruits(this.fruits);
        this.addSeeds(this.seeds);
    }

    @Override
    public ResourceLocation getForeground() {
        return new ResourceLocation("agricraft", "textures/gui/journal/GuiJournalSeedPage.png");
    }

    @Override
    public void addTooltip(int x, int y, List<String> toolTip) {
    }

    @Override
    public List<GuiComponent> getComponents() {
        ArrayList<GuiComponent> components = new ArrayList<GuiComponent>();
        components.add(this.getTitle());
        components.add(this.getDescriptionHead());
        components.add(this.getSeedInformation());
        components.add(this.getTier());
        components.add(this.getBrightnessTitle());
        components.add(this.getFruitTitle());
        components.add(this.getGrowthTitle());
        components.add(this.getMutationTitle());
        this.addSeed(components);
        this.addFruits(components);
        this.addSeeds(components);
        this.addBrightnessTextures(components);
        this.addMutationTemplates(components);
        this.addGrowthStageIcons(components);
        return components;
    }

    private GuiComponent<String> getTitle() {
        String text = this.plant.getPlantName();
        double scale = 0.8f;
        while ((double)Minecraft.func_71410_x().field_71466_p.func_78256_a(text) * scale > 74.0) {
            scale -= (double)0.1f;
        }
        return BasicComponents.getTextComponent(text, 82, 17, scale, true);
    }

    private GuiComponent<String> getDescriptionHead() {
        String text = AgriCore.getTranslator().translate("agricraft_journal.information") + ": ";
        return BasicComponents.getTextComponent(text, 29, 31, 0.5);
    }

    private GuiComponent<String> getSeedInformation() {
        return BasicComponents.getTextComponent(this.plant.getInformation(), 29, 38, 0.5);
    }

    private GuiComponent<String> getTier() {
        String text = AgriCore.getTranslator().translate("agricraft_journal.tier") + ": " + this.plant.getTier();
        return BasicComponents.getTextComponent(text, 29, 66, 0.5);
    }

    private GuiComponent<String> getBrightnessTitle() {
        String text = AgriCore.getTranslator().translate("agricraft_journal.brightness") + ": ";
        return BasicComponents.getTextComponent(text, 29, 76, 0.5);
    }

    private GuiComponent<String> getFruitTitle() {
        String text = AgriCore.getTranslator().translate("agricraft_journal.fruits") + ": ";
        return BasicComponents.getTextComponent(text, 29, 95, 0.5);
    }

    private GuiComponent<String> getGrowthTitle() {
        String text = AgriCore.getTranslator().translate("agricraft_journal.growthStages") + ": ";
        return BasicComponents.getTextComponent(text, 29, 122, 0.5);
    }

    private GuiComponent<String> getMutationTitle() {
        String text = AgriCore.getTranslator().translate("agricraft_journal.mutations") + ": ";
        return BasicComponents.getTextComponent(text, 132, 13, 0.5);
    }

    private void addSeed(List<GuiComponent> components) {
        components.add(BasicComponents.getStackComponent(this.plant.getSeed(), 26, 11));
    }

    private void addFruits(List<GuiComponent> components) {
        int x = 30;
        for (ItemStack stack : this.discoveredSeeds.get(this.page).getAllFruits()) {
            components.add(BasicComponents.getStackComponentFramed(stack, x, 102));
            x += 24;
        }
    }

    private void addSeeds(List<GuiComponent> components) {
        List<IAgriMutation> completedMutations = this.getCompletedMutations();
        List<IAgriMutation> uncompletedMutations = this.getUncompleteMutations();
        int y = 1;
        int x = 132;
        for (IAgriMutation mutation : completedMutations) {
            ItemStack resultStack = mutation.getChild().getSeed();
            GuiComponent<ItemStack> child = BasicComponents.getStackComponent(resultStack, x + 69, y += 20);
            child.setMouseClickAction((c, p) -> this.journal.switchPage(mutation.getChild()));
            components.add(child);
            ItemStack parent1Stack = mutation.getParents().get(0).getSeed();
            GuiComponent<ItemStack> parent1 = BasicComponents.getStackComponent(parent1Stack, x, y);
            parent1.setMouseClickAction((c, p) -> this.journal.switchPage(mutation.getParents().get(0)));
            components.add(parent1);
            ItemStack parent2Stack = mutation.getParents().get(1).getSeed();
            GuiComponent<ItemStack> parent2 = BasicComponents.getStackComponent(parent2Stack, x + 35, y);
            parent2.setMouseClickAction((c, p) -> this.journal.switchPage(mutation.getParents().get(1)));
            components.add(parent2);
        }
        for (IAgriMutation mutation : uncompletedMutations) {
            ItemStack parent1Stack = mutation.getParents().get(0).getSeed();
            GuiComponent<ItemStack> parent1 = BasicComponents.getStackComponent(parent1Stack, x, y += 20);
            parent1.setMouseClickAction((c, p) -> this.journal.switchPage(mutation.getParents().get(0)));
            components.add(parent1);
            ItemStack parent2Stack = mutation.getParents().get(1).getSeed();
            GuiComponent<ItemStack> parent2 = BasicComponents.getStackComponent(parent2Stack, x + 35, y);
            parent2.setMouseClickAction((c, p) -> this.journal.switchPage(mutation.getParents().get(1)));
            components.add(parent2);
        }
    }

    private List<IAgriMutation> getCompletedMutations() {
        List<IAgriMutation> mutations = this.getDiscoveredParentMutations();
        mutations.addAll(this.getDiscoveredChildMutations());
        return mutations;
    }

    private List<IAgriMutation> getDiscoveredParentMutations() {
        return MutationRegistry.getInstance().getMutationsForParent(this.discoveredSeeds.get(this.page)).stream().filter(this::isMutationDiscovered).collect(Collectors.toList());
    }

    private List<IAgriMutation> getDiscoveredChildMutations() {
        return MutationRegistry.getInstance().getMutationsForChild(this.discoveredSeeds.get(this.page)).stream().filter(this::isMutationDiscovered).collect(Collectors.toList());
    }

    private List<IAgriMutation> getUncompleteMutations() {
        return MutationRegistry.getInstance().getMutationsForParent(this.discoveredSeeds.get(this.page)).stream().filter(this::isMutationHalfDiscovered).collect(Collectors.toList());
    }

    private boolean isMutationDiscovered(IAgriMutation mutation) {
        return this.areParentsDiscovered(mutation) && this.isSeedDiscovered(mutation.getChild());
    }

    private boolean isMutationHalfDiscovered(IAgriMutation mutation) {
        return this.areParentsDiscovered(mutation) && !this.isSeedDiscovered(mutation.getChild());
    }

    private boolean areParentsDiscovered(IAgriMutation mutation) {
        return this.discoveredSeeds.containsAll(mutation.getParents());
    }

    private boolean isSeedDiscovered(IAgriPlant seed) {
        return this.discoveredSeeds.contains(seed);
    }

    private void addBrightnessTextures(List<GuiComponent> textures) {
        int x = 29;
        int y = 81;
        int u = 4;
        int v = 8;
        int[] brightnessRange = new int[]{this.plant.getGrowthRequirement().getMinLight(), this.plant.getGrowthRequirement().getMaxLight()};
        textures.add(BasicComponents.getIconComponent(BRIGHTNESS_BAR, x, y, 2 + 16 * u, v, Arrays.toString(brightnessRange)));
        textures.add(BasicComponents.getIconComponent(BRIGHTNESS_FRAME, x + u * brightnessRange[0], y, 1, v));
        textures.add(BasicComponents.getIconComponent(BRIGHTNESS_FRAME, x + u * brightnessRange[1] + 1, y, 1, v));
        textures.add(BasicComponents.getIconComponent(BRIGHTNESS_FRAME, x + u * brightnessRange[0] + 1, y, u * (brightnessRange[1] - brightnessRange[0]), 1));
        textures.add(BasicComponents.getIconComponent(BRIGHTNESS_FRAME, x + u * brightnessRange[0] + 1, y + v - 1, u * (brightnessRange[1] - brightnessRange[0]), 1));
    }

    private void addMutationTemplates(List<GuiComponent> components) {
        int i;
        int n = this.getCompletedMutations().size();
        int l = this.getUncompleteMutations().size();
        int y = 0;
        for (i = 0; i < n; ++i) {
            components.add(BasicComponents.getIconComponent(MUTATION_TEMPLATE, 132, y += 20, 86, 18));
        }
        for (i = 0; i < l; ++i) {
            components.add(BasicComponents.getIconComponent(MUTATION_TEMPLATE, 132, y += 20, 86, 18));
            components.add(BasicComponents.getIconComponent(QUESTION_MARK, 201, y + 1, 16, 16));
        }
    }

    private void addGrowthStageIcons(List<GuiComponent> components) {
        for (int i = 0; i < 8; ++i) {
            int x = 30 + 24 * (i % 4);
            int y = 129 + 24 * (i / 4);
            ResourceLocation loc = new ResourceLocation(this.plant.getPrimaryPlantTexture(i).toString().replace(":blocks/", ":textures/blocks/").concat(".png"));
            components.add(BasicComponents.getIconComponent(loc, x, y, 16, 16));
        }
    }
}

