/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.gui.component;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.gui.AgriGuiWrapper;
import com.infinityraider.agricraft.gui.component.GuiComponent;
import com.infinityraider.agricraft.utility.GuiHelper;
import java.awt.Color;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ComponentRenderer {
    public static final Color NORMAL_TEXT = new Color(0xE0E0E0);
    public static final Color ACTIVE_TEXT = new Color(0xFFFFA0);
    public static final Color DISABLED_TEXT = new Color(0xA0A0A0);
    public static final ResourceLocation WIDGETS = new ResourceLocation("agricraft:textures/gui/widgets.png");

    public static void renderIconComponent(AgriGuiWrapper gui, GuiComponent<ResourceLocation> component) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(component.getComponent());
        AgriGuiWrapper.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)component.getBounds().width, (int)component.getBounds().height, (float)component.getBounds().width, (float)component.getBounds().height);
    }

    public static void renderComponentProgressBar(AgriGuiWrapper gui, GuiComponent<Supplier<Integer>> component) {
        int width = component.getBounds().width;
        int height = component.getBounds().height;
        double progress = component.getComponent().get().intValue();
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS, (int)0, (int)0, (int)100, (int)25, (int)width, (int)height, (int)16, (int)16, (int)2, (float)0.0f);
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS, (int)0, (int)0, (int)125, (int)25, (int)((int)((double)width * progress / 100.0)), (int)height, (int)16, (int)16, (int)2, (float)0.0f);
    }

    public static void renderComponentButton(AgriGuiWrapper gui, GuiComponent<String> component) {
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS, (int)0, (int)0, (int)0, (int)(46 + ComponentRenderer.getButtonNumber(component) * 20), (int)component.getBounds().width, (int)component.getBounds().height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)0.0f);
        ComponentRenderer.renderComponentText(gui, component, ComponentRenderer.getTextColor(component), true);
    }

    public static int getButtonNumber(GuiComponent component) {
        if (!component.isEnabled()) {
            return 0;
        }
        if (!component.isHovered()) {
            return 1;
        }
        return 2;
    }

    public static Color getTextColor(GuiComponent component) {
        if (!component.isEnabled()) {
            return DISABLED_TEXT;
        }
        if (!component.isHovered()) {
            return NORMAL_TEXT;
        }
        return ACTIVE_TEXT;
    }

    public static void renderComponentStackFramed(AgriGuiWrapper gui, GuiComponent<ItemStack> component) {
        ComponentRenderer.renderStackFrame(gui, component);
        ComponentRenderer.renderComponentStack(gui, component);
    }

    public static void renderComponentStack(AgriGuiWrapper gui, GuiComponent<ItemStack> component) {
        gui.getItemRender().func_180450_b(component.getComponent(), 0, 0);
        GlStateManager.func_179141_d();
    }

    public static void renderStackFrame(AgriGuiWrapper gui, GuiComponent<ItemStack> component) {
        GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS, (int)-1, (int)-1, (int)142, (int)25, (int)18, (int)18, (int)18, (int)18, (int)2, (float)0.0f);
    }

    public static void renderComponentText(AgriGuiWrapper gui, GuiComponent<String> component) {
        ComponentRenderer.renderComponentText(gui, component, Color.BLACK, false);
    }

    public static void renderComponentText(AgriGuiWrapper gui, GuiComponent<String> component, Color color, boolean shadow) {
        FontRenderer fontRenderer = gui.getFontRenderer();
        String text = AgriCore.getTranslator().translate(component.getComponent());
        text = GuiHelper.splitInLines(gui.getFontRenderer(), text, 95.0, component.getScale());
        List<String> write = GuiHelper.getLinesFromData(text);
        float vertOffset = component.isCenteredVertically() ? (float)(component.getBounds().height - write.size() * fontRenderer.field_78288_b) / 2.0f : 0.0f;
        for (int i = 0; i < write.size(); ++i) {
            String line = write.get(i);
            float xOffset = component.isCenteredHorizontally() ? (float)(component.getBounds().width - fontRenderer.func_78256_a(line)) / 2.0f : 0.0f;
            float yOffset = vertOffset + (float)(i * fontRenderer.field_78288_b);
            fontRenderer.func_175065_a(line, xOffset, yOffset, color.hashCode(), shadow);
        }
    }
}

