/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation.statcalculator;

import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.stat.IAgriStatCalculator;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.farming.mutation.statcalculator.StatCalculatorBase;
import java.util.Optional;

public class StatCalculatorNormal
extends StatCalculatorBase {
    @Override
    protected int calculateStats(int input, int neighbours, int divisor) {
        if (neighbours == 1 && AgriCraftConfig.singleSpreadsIncrement) {
            neighbours = 2;
        }
        int newStat = Math.max(1, (input + (int)Math.round((double)Math.abs(neighbours - 1) * Math.random())) / divisor);
        return Math.min(newStat, AgriCraftConfig.cropStatCap);
    }

    @Override
    public boolean accepts(Object obj) {
        return !AgriCraftConfig.hardCoreStats && obj instanceof IAgriPlant;
    }

    @Override
    public Optional<IAgriStatCalculator> valueOf(Object obj) {
        return this.accepts(obj) ? Optional.of(this) : Optional.empty();
    }
}

