/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation.statcalculator;

import com.infinityraider.agricraft.api.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.api.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.api.stat.IAgriStatCalculator;
import com.infinityraider.agricraft.apiimpl.MutationRegistry;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.farming.PlantStats;
import java.util.List;

public abstract class StatCalculatorBase
implements IAgriStatCalculator,
IAgriAdapter<IAgriStatCalculator> {
    @Override
    public IAgriStat calculateStats(IAgriPlant child, List<? extends IAgriCrop> parents, boolean mutation) {
        parents.removeIf(p -> !p.isMature());
        int validParents = 0;
        int growth = 0;
        int gain = 0;
        int strength = 0;
        for (IAgriCrop iAgriCrop : parents) {
            if (!this.canInheritStats(child, iAgriCrop.getPlant().get())) continue;
            ++validParents;
            growth += iAgriCrop.getStat().get().getGrowth();
            gain += iAgriCrop.getStat().get().getGain();
            strength += iAgriCrop.getStat().get().getStrength();
        }
        int num = AgriCraftConfig.otherCropsAffectStatsNegatively ? parents.size() : validParents;
        num = num < 1 ? 1 : num;
        int n = mutation ? AgriCraftConfig.cropStatDivisor : 1;
        return new PlantStats(this.calculateStats(growth /= num, validParents, n), this.calculateStats(gain /= num, validParents, n), this.calculateStats(strength /= num, validParents, n));
    }

    protected boolean canInheritStats(IAgriPlant child, IAgriPlant parent) {
        int validParentId = AgriCraftConfig.validParents;
        switch (validParentId) {
            case 1: 
            case 2: {
                return child.equals(parent);
            }
            case 3: {
                if (child.equals(parent)) {
                    return true;
                }
                for (IAgriMutation mutation : MutationRegistry.getInstance().getMutationsForChild(child)) {
                    if (!mutation.getParents().contains(parent)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    protected abstract int calculateStats(int var1, int var2, int var3);
}

