/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation;

import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.api.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.apiimpl.StatCalculatorRegistry;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import java.util.List;
import java.util.Optional;
import java.util.Random;

public class SpreadStrategy
implements IAgriCrossStrategy {
    @Override
    public double getRollChance() {
        return Math.abs(1.0f - AgriCraftConfig.mutationChance);
    }

    @Override
    public Optional<AgriSeed> executeStrategy(IAgriCrop crop, Random rand) {
        int index;
        IAgriPlant plant;
        List<IAgriCrop> matureNeighbours = crop.getMatureNeighbours();
        if (!matureNeighbours.isEmpty() && (plant = matureNeighbours.get(index = rand.nextInt(matureNeighbours.size())).getPlant().get()) != null && rand.nextDouble() < plant.getSpreadChance()) {
            return StatCalculatorRegistry.getInstance().calculateStats(plant, matureNeighbours, false).map(stat -> new AgriSeed(plant, (IAgriStat)stat));
        }
        return Optional.empty();
    }
}

