/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.mutation;

import com.agricraft.agricore.util.MathHelper;
import com.infinityraider.agricraft.api.mutation.IAgriMutation;
import com.infinityraider.agricraft.api.plant.IAgriPlant;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;

public class Mutation
implements IAgriMutation {
    private final double chance;
    @Nonnull
    private final IAgriPlant child;
    @Nonnull
    private final List<IAgriPlant> parents;

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public IAgriPlant getChild() {
        return this.child;
    }

    @Override
    public List<IAgriPlant> getParents() {
        return this.parents;
    }

    public boolean equals(Object object) {
        if (object instanceof IAgriMutation) {
            IAgriMutation other = (IAgriMutation)object;
            return other.hasChild(this.child) && other.hasParent(this.parents);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IAgriPlant p : this.parents) {
            sb.append(p.getPlantName()).append(" + ");
        }
        sb.replace(sb.length() - 3, sb.length(), " = ");
        sb.append(this.child.getPlantName());
        return sb.toString();
    }

    public Mutation(double chance, @Nonnull IAgriPlant child, IAgriPlant ... parents) {
        this(chance, child, Arrays.asList(parents));
    }

    public Mutation(double chance, IAgriPlant child, List<IAgriPlant> parents) {
        this.chance = MathHelper.inRange(chance, 0.0, 1.0);
        this.child = child;
        this.parents = parents;
    }
}

