/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.growthrequirement;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.plant.AgriStack;
import com.infinityraider.agricraft.api.requirement.IGrowthReqBuilder;
import com.infinityraider.agricraft.api.util.FuzzyStack;
import com.infinityraider.agricraft.apiimpl.SoilRegistry;
import com.infinityraider.agricraft.farming.growthrequirement.GrowthReqBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class GrowthRequirementHandler {
    public static List<FuzzyStack> defaultSoils = new ArrayList<FuzzyStack>();

    public static IGrowthReqBuilder getNewBuilder() {
        return new GrowthReqBuilder();
    }

    public static boolean isSoilValid(IBlockAccess world, BlockPos pos) {
        return FuzzyStack.fromBlockState(world.func_180495_p(pos)).filter(soil -> SoilRegistry.getInstance().isSoil((FuzzyStack)soil) || defaultSoils.contains(soil)).isPresent();
    }

    public static void init() {
        GrowthRequirementHandler.registerSoils();
        GrowthRequirementHandler.registerCustomEntries();
    }

    private static void registerSoils() {
        GrowthRequirementHandler.addDefaultSoil(new FuzzyStack(new ItemStack(Blocks.field_150458_ak)));
    }

    private static void registerCustomEntries() {
        AgriCore.getLogger("AgriCraft").info("Registering soils to whitelist:", new Object[0]);
        String[] data = new String[]{"minecraft:dirt"};
        String total = " of " + data.length + ".";
        for (String line : data) {
            Block block;
            AgriCore.getLogger("AgriCraft").debug("  Parsing " + line + total, new Object[0]);
            ItemStack stack = ((FuzzyStack)AgriStack.fromString(line).toStack()).toStack();
            Block block2 = block = stack != null && stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).field_150939_a : null;
            if (block != null) {
                GrowthRequirementHandler.addDefaultSoil(new FuzzyStack(new ItemStack(block, stack.func_77952_i())));
                continue;
            }
            AgriCore.getLogger("AgriCraft").info(" Error when adding block to soil whitelist: Invalid block (line: " + line + ")", new Object[0]);
        }
        AgriCore.getLogger("AgriCraft").info("Completed soil whitelist:", new Object[0]);
    }

    public static void addAllToSoilWhitelist(Collection<? extends FuzzyStack> list) {
        for (FuzzyStack fuzzyStack : list) {
            GrowthRequirementHandler.addDefaultSoil(fuzzyStack);
        }
    }

    public static void removeAllFromSoilWhitelist(Collection<? extends FuzzyStack> list) {
        defaultSoils.removeAll(list);
    }

    public static boolean addDefaultSoil(FuzzyStack block) {
        if (!defaultSoils.contains(block)) {
            defaultSoils.add(block);
            return true;
        }
        return false;
    }
}

