/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming.growthrequirement;

import com.agricraft.agricore.util.MathHelper;
import com.infinityraider.agricraft.api.requirement.ICondition;
import com.infinityraider.agricraft.api.requirement.IGrowthReqBuilder;
import com.infinityraider.agricraft.api.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.soil.IAgriSoil;
import com.infinityraider.agricraft.farming.growthrequirement.GrowthRequirement;
import java.util.ArrayList;
import java.util.List;

public class GrowthReqBuilder
implements IGrowthReqBuilder {
    private final List<IAgriSoil> soils = new ArrayList<IAgriSoil>();
    private final List<ICondition> conditions = new ArrayList<ICondition>();
    private int minLight = 0;
    private int maxLight = 16;

    @Override
    public GrowthReqBuilder addSoil(IAgriSoil soil) {
        this.soils.add(soil);
        return this;
    }

    @Override
    public IGrowthReqBuilder addCondition(ICondition condition) {
        this.conditions.add(condition);
        return this;
    }

    @Override
    public IGrowthReqBuilder setMinLight(int minLight) {
        this.minLight = MathHelper.inRange(minLight, 0, 16);
        return this;
    }

    @Override
    public IGrowthReqBuilder setMaxLight(int maxLight) {
        this.maxLight = MathHelper.inRange(maxLight, 0, 16);
        return this;
    }

    @Override
    public IGrowthRequirement build() {
        return new GrowthRequirement(this.soils, this.conditions, this.minLight, this.maxLight);
    }
}

