/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.util.MathHelper;
import com.infinityraider.agricraft.api.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.utility.NBTHelper;
import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.NBTTagCompound;

public class PlantStats
implements IAgriStat,
IAgriAdapter<IAgriStat> {
    public static final String NBT_GROWTH = "agri_growth";
    public static final String NBT_GAIN = "agri_gain";
    public static final String NBT_STRENGTH = "agri_strength";
    public static final String NBT_ANALYZED = "agri_analyzed";
    private static final byte MAX = (byte)AgriCraftConfig.cropStatCap;
    private static final byte MIN = 1;
    private final byte growth;
    private final byte gain;
    private final byte strength;
    private final boolean analyzed;

    public PlantStats() {
        this(1, 1, 1, false);
    }

    public PlantStats(int growth, int gain, int strength) {
        this(growth, gain, strength, false);
    }

    public PlantStats(int growth, int gain, int strength, boolean analyzed) {
        this.growth = (byte)MathHelper.inRange(growth, 1, MAX);
        this.gain = (byte)MathHelper.inRange(gain, 1, MAX);
        this.strength = (byte)MathHelper.inRange(strength, 1, MAX);
        this.analyzed = analyzed;
    }

    @Override
    public boolean isAnalyzed() {
        return this.analyzed;
    }

    @Override
    public byte getGrowth() {
        return this.growth;
    }

    @Override
    public byte getGain() {
        return this.gain;
    }

    @Override
    public byte getStrength() {
        return this.strength;
    }

    @Override
    public byte getMaxGrowth() {
        return MAX;
    }

    @Override
    public byte getMaxGain() {
        return MAX;
    }

    @Override
    public byte getMaxStrength() {
        return MAX;
    }

    @Override
    public IAgriStat withAnalyzed(boolean analyzed) {
        return new PlantStats(this.growth, this.gain, this.strength, analyzed);
    }

    @Override
    public IAgriStat withGrowth(int growth) {
        return new PlantStats(growth, this.gain, this.strength, this.analyzed);
    }

    @Override
    public IAgriStat withGain(int gain) {
        return new PlantStats(this.growth, gain, this.strength, this.analyzed);
    }

    @Override
    public IAgriStat withStrength(int strength) {
        return new PlantStats(this.growth, this.gain, strength, this.analyzed);
    }

    @Override
    public boolean writeToNBT(NBTTagCompound tag) {
        tag.func_74774_a(NBT_GROWTH, this.growth);
        tag.func_74774_a(NBT_GAIN, this.gain);
        tag.func_74774_a(NBT_STRENGTH, this.strength);
        tag.func_74757_a(NBT_ANALYZED, this.analyzed);
        return true;
    }

    @Override
    public boolean addStats(List<String> lines) {
        try {
            lines.add(MessageFormat.format(AgriCraftConfig.STAT_FORMAT, AgriCore.getTranslator().translate("agricraft_tooltip.growth"), this.getGrowth(), AgriCraftConfig.cropStatCap));
            lines.add(MessageFormat.format(AgriCraftConfig.STAT_FORMAT, AgriCore.getTranslator().translate("agricraft_tooltip.gain"), this.getGain(), AgriCraftConfig.cropStatCap));
            lines.add(MessageFormat.format(AgriCraftConfig.STAT_FORMAT, AgriCore.getTranslator().translate("agricraft_tooltip.strength"), this.getStrength(), AgriCraftConfig.cropStatCap));
            return true;
        }
        catch (IllegalArgumentException e) {
            lines.add("Invalid Stat Format!");
            return false;
        }
    }

    @Override
    public boolean accepts(Object obj) {
        NBTTagCompound tag = NBTHelper.asTag(obj);
        return tag != null && NBTHelper.hasKey(tag, NBT_GROWTH, NBT_GAIN, NBT_STRENGTH, NBT_ANALYZED);
    }

    @Override
    public Optional<IAgriStat> valueOf(Object obj) {
        NBTTagCompound tag = NBTHelper.asTag(obj);
        if (tag != null) {
            return Optional.of(new PlantStats(tag.func_74771_c(NBT_GROWTH), tag.func_74771_c(NBT_GAIN), tag.func_74771_c(NBT_STRENGTH), tag.func_74767_n(NBT_ANALYZED)));
        }
        return Optional.empty();
    }
}

