/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.farming;

import com.infinityraider.agricraft.api.plant.IAgriPlant;
import com.infinityraider.agricraft.api.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.util.FuzzyStack;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.reference.Constants;
import com.infinityraider.agricraft.renderers.PlantRenderer;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class CropPlant
implements IAgriPlant {
    private final IGrowthRequirement growthRequirement;
    private boolean blackListed;
    private boolean ignoreVanillaPlantingRule;

    public CropPlant(IGrowthRequirement requirement) {
        this.growthRequirement = Objects.requireNonNull(requirement, "A CropPlant's growth requirement may not be null!");
        this.blackListed = false;
        this.ignoreVanillaPlantingRule = false;
    }

    public final int getGrowthRate() {
        int tier = this.getTier();
        if (tier > 0 && tier <= Constants.GROWTH_TIER.length) {
            return Constants.GROWTH_TIER[tier];
        }
        return Constants.GROWTH_TIER[0];
    }

    public final boolean isBlackListed() {
        return this.blackListed;
    }

    public final void setBlackListStatus(boolean status) {
        this.blackListed = status;
    }

    public final boolean ingoresVanillaPlantingRule() {
        return this.ignoreVanillaPlantingRule;
    }

    public final void setIgnoreVanillaPlantingRule(boolean value) {
        this.ignoreVanillaPlantingRule = value;
    }

    @Override
    public Collection<FuzzyStack> getSeedItems() {
        return Arrays.asList(new FuzzyStack(new ItemStack((Item)AgriItems.getInstance().AGRI_SEED)));
    }

    @Override
    public final ItemStack getSeed() {
        ItemStack stack = this.getSeedItems().stream().map(s -> s.toStack()).findFirst().orElse(new ItemStack((Item)AgriItems.getInstance().AGRI_SEED));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("agri_seed", this.getId());
        new PlantStats().writeToNBT(tag);
        stack.func_77982_d(tag);
        return stack;
    }

    @Override
    public final IGrowthRequirement getGrowthRequirement() {
        return this.growthRequirement;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getPlantQuads(IExtendedBlockState state, int growthStage, EnumFacing direction, Function<ResourceLocation, TextureAtlasSprite> textureToIcon) {
        if (textureToIcon instanceof ITessellator) {
            PlantRenderer.renderPlant((ITessellator)textureToIcon, this, growthStage);
        }
        return Collections.emptyList();
    }
}

