/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.entity.villager;

import com.infinityraider.agricraft.entity.villager.EntityVillagerFarmer;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class EntityAIClearWeeds
extends EntityAIBase {
    @Nonnull
    private static final int CLEAR_RANGE = 8;
    @Nonnull
    private final EntityVillagerFarmer villager;
    @Nonnull
    private List<TileEntityCrop> weedsToClear;
    @Nullable
    private TileEntityCrop nextCrop;

    public EntityAIClearWeeds(EntityVillagerFarmer villager) {
        if (villager == null) {
            throw new NullPointerException("Attack of the Ghost Farmer! No, seriously, you passed a null entity.");
        }
        this.villager = villager;
        this.weedsToClear = new ArrayList<TileEntityCrop>();
    }

    public boolean func_75250_a() {
        return !this.villager.field_70128_L && !this.villager.func_70940_q();
    }

    public boolean func_75253_b() {
        return this.func_75250_a() && !this.isTaskFinished();
    }

    public boolean isTaskFinished() {
        return this.weedsToClear.isEmpty() && this.nextCrop == null;
    }

    public boolean func_75252_g() {
        return true;
    }

    public void func_75249_e() {
        this.findWeeds();
        this.getNextCrop();
    }

    public void func_75251_c() {
        this.func_75249_e();
    }

    public void func_75246_d() {
        if (this.isTaskFinished()) {
            this.func_75251_c();
        }
        if (this.nextCrop != null) {
            double dist = this.getDistanceFromCrop();
            if (dist < 0.0) {
                this.getNextCrop();
            } else if (dist <= 1.0) {
                this.nextCrop.clearWeed();
                this.getNextCrop();
            } else if (!this.villager.func_70661_as().func_75492_a((double)this.nextCrop.xCoord() + 0.5, (double)this.nextCrop.yCoord(), (double)this.nextCrop.zCoord() + 0.5, 1.0)) {
                this.getNextCrop();
            }
        } else {
            this.getNextCrop();
        }
    }

    private void getNextCrop() {
        Iterator<TileEntityCrop> it = this.weedsToClear.iterator();
        this.nextCrop = null;
        while (it.hasNext() && this.nextCrop == null) {
            this.nextCrop = it.next();
            it.remove();
            if (this.villager.func_70661_as().func_75492_a((double)this.nextCrop.xCoord() + 0.5, (double)this.nextCrop.yCoord(), (double)this.nextCrop.zCoord() + 0.5, 1.0)) continue;
            this.nextCrop = null;
        }
    }

    private double getDistanceFromCrop() {
        if (this.nextCrop == null) {
            return -1.0;
        }
        double dx = this.villager.field_70165_t - ((double)this.nextCrop.xCoord() + 0.5);
        double dy = this.villager.field_70163_u - (double)this.nextCrop.yCoord();
        double dz = this.villager.field_70161_v - ((double)this.nextCrop.zCoord() + 0.5);
        return dx * dx + dy * dy + dz * dz;
    }

    private void findWeeds() {
        this.weedsToClear.clear();
        for (int dx = -8; dx < 8; ++dx) {
            for (int dy = -8; dy < 8; ++dy) {
                for (int dz = -8; dz < 8; ++dz) {
                    TileEntityCrop crop;
                    int x = (int)this.villager.field_70165_t + dx;
                    int y = (int)this.villager.field_70163_u + dy;
                    int z = (int)this.villager.field_70161_v + dz;
                    TileEntity te = this.villager.field_70170_p.func_175625_s(new BlockPos(x, y, z));
                    if (te == null || !(te instanceof TileEntityCrop) || !(crop = (TileEntityCrop)te).canWeed()) continue;
                    this.weedsToClear.add(crop);
                }
            }
        }
    }
}

