/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.container;

import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.network.MessageContainerSeedStorage;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageControllable;
import com.infinityraider.agricraft.tiles.storage.ISeedStorageController;
import com.infinityraider.agricraft.tiles.storage.SeedStorageSlot;
import com.infinityraider.infinitylib.container.ContainerBase;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;

public abstract class ContainerSeedStorageBase
extends ContainerBase {
    public ContainerSeedStorageBase(InventoryPlayer inventory, int xOffset, int yOffset) {
        super(inventory, xOffset, yOffset);
    }

    public abstract boolean addSeedToStorage(ItemStack var1);

    public abstract List<ItemStack> getSeedEntries();

    public abstract List<SeedStorageSlot> getSeedSlots(AgriSeed var1);

    public abstract TileEntity getTileEntity();

    public Optional<ISeedStorageControllable> getControllable(ItemStack stack) {
        TileEntity te = this.getTileEntity();
        if (te instanceof ISeedStorageController) {
            return ((ISeedStorageController)te).getControllable(stack);
        }
        if (te instanceof ISeedStorageControllable) {
            return Optional.of((ISeedStorageControllable)te);
        }
        return Optional.empty();
    }

    public List<ItemStack> func_75138_a() {
        return super.func_75138_a();
    }

    public void moveStackFromTileEntityToPlayer(int slotId, ItemStack stack) {
        ISeedStorageControllable controllable = this.getControllable(stack).orElse(null);
        if (controllable == null) {
            return;
        }
        ItemStack stackToMove = controllable.getStackForSlotId(slotId);
        if (stack == null) {
            return;
        }
        if (stackToMove == null || stackToMove.func_77973_b() == null) {
            return;
        }
        stackToMove.field_77994_a = stack.field_77994_a > stackToMove.field_77994_a ? stackToMove.field_77994_a : stack.field_77994_a;
        stackToMove.func_77982_d(controllable.getStackForSlotId(slotId).func_77978_p());
        if (this.func_75135_a(stackToMove, 0, PLAYER_INVENTORY_SIZE, false)) {
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                new MessageContainerSeedStorage(stack, slotId).sendToServer();
            } else {
                controllable.decreaseStackSizeInSlot(slotId, stack.field_77994_a - stackToMove.field_77994_a);
            }
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int clickedSlot) {
        ItemStack originalStackInSlot = null;
        Slot slot = (Slot)this.field_75151_b.get(clickedSlot);
        if (slot != null && slot.func_75216_d()) {
            ItemStack notMergedStack = slot.func_75211_c();
            originalStackInSlot = notMergedStack.func_77946_l();
            AgriSeed seed = SeedRegistry.getInstance().valueOf(notMergedStack).orElse(null);
            if (seed != null && seed.getStat().isAnalyzed()) {
                ISeedStorageControllable controllable = this.getControllable(notMergedStack).orElse(null);
                if (controllable != null && controllable.hasLockedSeed()) {
                    ItemStack locked = controllable.getLockedSeed().map(s -> s.toStack()).orElse(null);
                    if (notMergedStack.func_77973_b() != locked.func_77973_b() || notMergedStack.func_77952_i() != locked.func_77952_i()) {
                        return null;
                    }
                }
                if (this.addSeedToStorage(notMergedStack)) {
                    notMergedStack.field_77994_a = 0;
                } else {
                    return null;
                }
            }
            if (notMergedStack.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (notMergedStack.field_77994_a == originalStackInSlot.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, notMergedStack);
        }
        return originalStackInSlot;
    }

    protected boolean func_75135_a(ItemStack stack, int startSlot, int endSlot, boolean iterateBackwards) {
        ItemStack currentStack;
        Slot currentSlot;
        int k;
        boolean flag = false;
        int n = k = iterateBackwards ? endSlot - 1 : startSlot;
        while (stack.field_77994_a > 0 && (!iterateBackwards && k < endSlot || iterateBackwards && k >= startSlot)) {
            currentSlot = (Slot)this.field_75151_b.get(k);
            currentStack = currentSlot.func_75211_c();
            if (currentStack != null && currentStack.func_77973_b() == stack.func_77973_b() && (!stack.func_77981_g() || stack.func_77952_i() == currentStack.func_77952_i()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)currentStack)) {
                int l = currentStack.field_77994_a + stack.field_77994_a;
                if (l <= stack.func_77976_d()) {
                    stack.field_77994_a = 0;
                    currentStack.field_77994_a = l;
                    currentSlot.func_75218_e();
                    flag = true;
                } else if (currentStack.field_77994_a < stack.func_77976_d()) {
                    stack.field_77994_a -= stack.func_77976_d() - currentStack.field_77994_a;
                    currentStack.field_77994_a = stack.func_77976_d();
                    currentSlot.func_75218_e();
                    flag = true;
                }
            }
            k = iterateBackwards ? k - 1 : k + 1;
        }
        if (stack.field_77994_a > 0) {
            int n2 = k = iterateBackwards ? endSlot - 1 : startSlot;
            while (!iterateBackwards && k < endSlot || iterateBackwards && k >= startSlot) {
                currentSlot = (Slot)this.field_75151_b.get(k);
                currentStack = currentSlot.func_75211_c();
                if (currentStack == null) {
                    currentSlot.func_75215_d(stack.func_77946_l());
                    currentSlot.func_75218_e();
                    stack.field_77994_a = 0;
                    flag = true;
                    break;
                }
                k = iterateBackwards ? k - 1 : k + 1;
            }
        }
        return flag;
    }
}

