/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.compat.computer.renderers;

import com.infinityraider.agricraft.compat.computer.blocks.BlockPeripheral;
import com.infinityraider.agricraft.compat.computer.tiles.TileEntityPeripheral;
import com.infinityraider.agricraft.renderers.models.ModelPeripheralProbe;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.block.BlockBase;
import com.infinityraider.infinitylib.block.tile.TileEntityBase;
import com.infinityraider.infinitylib.render.block.RenderBlockWithTileBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderPeripheral
extends RenderBlockWithTileBase<BlockPeripheral, TileEntityPeripheral> {
    public static final ResourceLocation TEXTURE_TOP = new ResourceLocation("agricraft:blocks/peripheralTop");
    public static final ResourceLocation TEXTURE_SIDE = new ResourceLocation("agricraft:blocks/peripheralSide");
    public static final ResourceLocation TEXTURE_BOTTOM = new ResourceLocation("agricraft:blocks/peripheralBottom");
    public static final ResourceLocation TEXTURE_INNER = new ResourceLocation("agricraft:blocks/peripheralInner");
    private static final ResourceLocation probeTexture = new ResourceLocation("agricraft:textures/blocks/peripheralProbe.png");
    private static final ModelBase probeModel = new ModelPeripheralProbe();

    public RenderPeripheral(BlockPeripheral block) {
        super((BlockBase)block, (TileEntityBase)new TileEntityPeripheral(), true, true, true);
    }

    public void renderWorldBlockStatic(ITessellator tessellator, IBlockState state, BlockPeripheral block, EnumFacing side) {
        this.renderBase(tessellator);
    }

    public void renderWorldBlockDynamic(ITessellator tessellator, World world, BlockPos pos, double x, double y, double z, BlockPeripheral block, @Nullable TileEntityPeripheral tile, float partialTick, int destroyStage) {
        this.drawSeed(tessellator, tile);
        this.performAnimations(tessellator, tile, BaseIcons.DEBUG.getIcon());
    }

    public void renderInventoryBlock(ITessellator tessellator, World world, IBlockState state, BlockPeripheral block, @Nullable TileEntityPeripheral tile, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type) {
        this.renderBase(tessellator);
    }

    private void drawSeed(ITessellator tessellator, TileEntityPeripheral peripheral) {
        ItemStack stack = peripheral.func_70301_a(36);
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        TextureAtlasSprite icon = Minecraft.func_71410_x().func_147117_R().func_174944_f();
        if (icon == null) {
            return;
        }
        float dx = 0.25f;
        float dy = 0.875f;
        float dz = 0.25f;
        float scale = 0.5f;
        float angle = 90.0f;
        GL11.glPushMatrix();
        GL11.glTranslated((double)dx, (double)dy, (double)dz);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glRotatef((float)angle, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-angle), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)(1.0f / scale), (float)(1.0f / scale), (float)(1.0f / scale));
        GL11.glTranslated((double)(-dx), (double)(-dy), (double)(-dz));
        GL11.glPopMatrix();
    }

    private void performAnimations(ITessellator tessellator, TileEntityPeripheral peripheral, TextureAtlasSprite icon) {
        int maxDoorPos = 30;
        float unit = 0.0625f;
        GL11.glPushMatrix();
        for (EnumFacing dir : TileEntityPeripheral.VALID_DIRECTIONS) {
            int timer = peripheral.getTimer(dir);
            float doorPosition = (float)(timer >= maxDoorPos ? maxDoorPos : timer) * 4.0f / (float)maxDoorPos;
            if (doorPosition < 4.0f) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                tessellator.drawScaledPrism(4.0f, 2.0f, 0.0f, 8.0f - doorPosition, 14.0f, 1.0f, icon);
                tessellator.drawScaledPrism(8.0f + doorPosition, 2.0f, 0.0f, 12.0f, 14.0f, 1.0f, icon);
            }
            float probePosition = (timer < maxDoorPos ? 0 : timer - maxDoorPos) * 90 / maxDoorPos;
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float dx = -0.5f;
            float dy = -1.5f;
            float dz = 9.0f * unit;
            GL11.glTranslatef((float)dx, (float)dy, (float)dz);
            float dX = 0.0f;
            float dY = 21.5f * unit;
            float dZ = -5.5f * unit;
            GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
            GL11.glRotatef((float)probePosition, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-dX), (float)(-dY), (float)(-dZ));
            Minecraft.func_71410_x().field_71446_o.func_110577_a(probeTexture);
            probeModel.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            GL11.glTranslatef((float)dX, (float)dY, (float)dZ);
            GL11.glRotatef((float)(-probePosition), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-dX), (float)(-dY), (float)(-dZ));
            GL11.glTranslatef((float)(-dx), (float)(-dy), (float)(-dz));
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        }
        GL11.glPopMatrix();
    }

    private void renderBase(ITessellator tessellator) {
        TextureAtlasSprite iconTop = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_TOP);
        TextureAtlasSprite iconSide = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_SIDE);
        TextureAtlasSprite iconBottom = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_BOTTOM);
        TextureAtlasSprite iconInside = RenderPeripheral.getIcon((ResourceLocation)TEXTURE_INNER);
        float unit = 0.0625f;
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.UP, iconTop, 1.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.DOWN, iconBottom, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, iconSide, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.EAST, iconSide, 1.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.WEST, iconSide, 0.0f);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.SOUTH, iconSide, 1.0f);
        tessellator.drawScaledFace(4.0f, 4.0f, 12.0f, 12.0f, EnumFacing.UP, iconBottom, 12.0f * unit);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.NORTH, iconInside, 4.0f * unit);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.EAST, iconInside, 12.0f * unit);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.WEST, iconInside, 4.0f * unit);
        tessellator.drawScaledFaceDouble(0.0f, 0.0f, 16.0f, 16.0f, EnumFacing.SOUTH, iconInside, 12.0f * unit);
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        list.add(TEXTURE_TOP);
        list.add(TEXTURE_SIDE);
        list.add(TEXTURE_BOTTOM);
        list.add(TEXTURE_INNER);
        return list;
    }

    public TextureAtlasSprite getIcon() {
        return null;
    }

    public boolean applyAmbientOcclusion() {
        return false;
    }
}

