/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderTank;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityTank;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWaterTank
extends BlockCustomWood<TileEntityTank> {
    public static final InfinityProperty<TileEntityTank.Connection>[] CONNECTION_PROPERTIES = new InfinityProperty[]{AgriProperties.TANK_DOWN, AgriProperties.TANK_UP, AgriProperties.TANK_NORTH, AgriProperties.TANK_SOUTH, AgriProperties.TANK_WEST, AgriProperties.TANK_EAST};

    public BlockWaterTank() {
        super("water_tank");
    }

    public TileEntityTank createNewTileEntity(World world, int meta) {
        return new TileEntityTank();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack stack, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean update = false;
        if (world.field_72995_K) {
            return true;
        }
        TileEntityTank tank = WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityTank.class).orElse(null);
        if (stack != null && stack.func_77973_b() != null && tank != null) {
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (liquid != null && liquid.getFluid() == FluidRegistry.WATER) {
                int quantity = tank.fill(null, liquid, false);
                if (quantity == liquid.amount) {
                    tank.fill(null, liquid, true);
                    update = true;
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (stack.field_77994_a == 1) {
                            if (stack.func_77973_b().hasContainerItem(stack)) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack.func_77973_b().getContainerItem(stack));
                            } else {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            }
                        } else {
                            stack.func_77979_a(1);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                        }
                    }
                }
            } else {
                ItemStack filledContainer;
                FluidStack filledLiquid;
                FluidStack tankContents = tank.getTankInfo(null)[0].fluid;
                if (tankContents != null && (filledLiquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)tankContents, (ItemStack)stack)))) != null) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (stack.field_77994_a == 1) {
                            if (stack.func_77973_b().hasContainerItem(stack)) {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack.func_77973_b().getContainerItem(stack));
                            } else {
                                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                            }
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledContainer);
                        } else {
                            if (!player.field_71071_by.func_70441_a(filledContainer)) {
                                return false;
                            }
                            stack.func_77979_a(1);
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack);
                            player.field_71071_by.func_70441_a(filledContainer);
                            player.field_71071_by.func_70296_d();
                        }
                    }
                    tank.drain(null, filledLiquid.amount, true);
                    update = true;
                }
            }
        }
        return update;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderTank getRenderer() {
        return new RenderTank(this);
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        return CONNECTION_PROPERTIES;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Optional tile = WorldHelper.getTile((IBlockAccess)worldIn, (BlockPos)pos, TileEntityTank.class);
        if (tile.isPresent()) {
            TileEntityTank tank = (TileEntityTank)tile.get();
            for (EnumFacing facing : EnumFacing.values()) {
                state = CONNECTION_PROPERTIES[facing.ordinal()].applyToBlockState(state, (Comparable)((Object)tank.getConnectionType(facing)));
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }
}

