/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks.irrigation;

import com.infinityraider.agricraft.blocks.BlockCustomWood;
import com.infinityraider.agricraft.config.AgriCraftConfig;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.IExtendedBlockState;

public abstract class AbstractBlockWaterChannel<T extends TileEntityChannel>
extends BlockCustomWood<T> {
    public static final InfinityProperty<Boolean>[] CONNECTION_PROPERTIES = new InfinityProperty[]{AgriProperties.CHANNEL_SOUTH, AgriProperties.CHANNEL_WEST, AgriProperties.CHANNEL_NORTH, AgriProperties.CHANNEL_EAST};

    public AbstractBlockWaterChannel(String subtype) {
        super("water_channel_" + subtype);
    }

    @Override
    protected InfinityProperty[] getPropertyArray() {
        return CONNECTION_PROPERTIES;
    }

    @Override
    protected IExtendedBlockState getExtendedCustomWoodState(IExtendedBlockState state, Optional<T> tile) {
        if (tile.isPresent()) {
            TileEntityChannel channel = (TileEntityChannel)tile.get();
            channel.checkConnections();
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                state = (IExtendedBlockState)CONNECTION_PROPERTIES[facing.func_176736_b()].applyToBlockState((IBlockState)state, (Comparable)Boolean.valueOf(channel.hasNeighbor(facing)));
            }
        }
        return state;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityChannel.class).ifPresent(TileEntityChannel::checkConnections);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean isEnabled() {
        return AgriCraftConfig.enableIrrigation;
    }
}

