/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.blocks;

import com.infinityraider.agricraft.api.crop.IAgriCrop;
import com.infinityraider.agricraft.farming.growthrequirement.GrowthRequirementHandler;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.agricraft.reference.AgriProperties;
import com.infinityraider.agricraft.renderers.blocks.RenderCrop;
import com.infinityraider.agricraft.tiles.TileEntityCrop;
import com.infinityraider.infinitylib.block.BlockTileCustomRenderedBase;
import com.infinityraider.infinitylib.block.blockstate.InfinityProperty;
import com.infinityraider.infinitylib.utility.WorldHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCrop
extends BlockTileCustomRenderedBase<TileEntityCrop>
implements IGrowable,
IPlantable {
    public static final AxisAlignedBB BOX = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 0.8125, 0.875);

    public BlockCrop() {
        super("crop", Material.field_151585_k);
        this.func_149675_a(true);
        this.field_149758_A = true;
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.0f);
        this.func_149647_a(null);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public TileEntityCrop createNewTileEntity(World world, int meta) {
        return new TileEntityCrop();
    }

    public Optional<TileEntityCrop> getCrop(IBlockAccess world, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCrop.class);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            this.getCrop((IBlockAccess)world, pos).ifPresent(TileEntityCrop::growthTick);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.getCrop((IBlockAccess)world, pos).map(crop -> crop.onCropRightClicked(player, heldItem)).orElse(false);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        this.getCrop((IBlockAccess)world, pos).ifPresent(crop -> crop.onCropLeftClicked(player));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_180649_a(world, pos, player);
    }

    public void func_180653_a(World world, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (!world.field_72995_K) {
            this.getCrop((IBlockAccess)world, pos).ifPresent(crop -> crop.getDrops(drop -> BlockCrop.func_180635_a((World)world, (BlockPos)pos, (ItemStack)drop)));
        }
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return this.getCrop((IBlockAccess)world, pos).map(crop -> !crop.isMature()).orElse(false);
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.getCrop((IBlockAccess)world, pos).ifPresent(TileEntityCrop::applyBoneMeal);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        if (!this.canBlockStay((IBlockAccess)worldIn, pos)) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175713_t(pos);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean canBlockStay(IBlockAccess world, BlockPos pos) {
        return GrowthRequirementHandler.isSoilValid(world, pos.func_177977_b());
    }

    public boolean isFertile(World world, BlockPos pos) {
        return this.getCrop((IBlockAccess)world, pos).map(IAgriCrop::isFertile).orElse(false);
    }

    public boolean isMature(World world, BlockPos pos) {
        return this.getCrop((IBlockAccess)world, pos).map(TileEntityCrop::isMature).orElse(false);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return AgriItems.getInstance().CROPS;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.getCrop(world, pos).ifPresent(c -> c.getDrops(drops::add));
        return drops;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        world.func_175713_t(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)AgriItems.getInstance().CROPS);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOX;
    }

    @Nullable
    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    @Deprecated
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return BOX.func_186670_a(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public RenderCrop getRenderer() {
        return new RenderCrop(this);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getBlockModelResourceLocation() {
        return new ModelResourceLocation("agricraft".toLowerCase() + ":" + this.getInternalName());
    }

    public List<String> getOreTags() {
        return Collections.emptyList();
    }

    protected InfinityProperty[] getPropertyArray() {
        return new InfinityProperty[0];
    }

    public Class<? extends ItemBlock> getItemBlockClass() {
        return null;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Crop;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    public Optional<TileEntityCrop> getCropTile(IBlockAccess world, BlockPos pos) {
        return WorldHelper.getTile((IBlockAccess)world, (BlockPos)pos, TileEntityCrop.class);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        Optional<TileEntityCrop> tile = this.getCropTile(world, pos);
        return ((IExtendedBlockState)state).withProperty(AgriProperties.CROP_PLANT, tile.flatMap(TileEntityCrop::getPlant).orElse(null)).withProperty(AgriProperties.GROWTH_STAGE, (Object)tile.map(TileEntityCrop::getGrowthStage).orElse(0)).withProperty(AgriProperties.CROSS_CROP, (Object)tile.map(TileEntityCrop::isCrossCrop).orElse(false));
    }

    public IUnlistedProperty[] getUnlistedPropertyArray() {
        return new IUnlistedProperty[]{AgriProperties.CROP_PLANT, AgriProperties.GROWTH_STAGE, AgriProperties.CROSS_CROP};
    }
}

