/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.apiimpl;

import com.agricraft.agricore.core.AgriCore;
import com.infinityraider.agricraft.api.AgriPlugin;
import com.infinityraider.agricraft.api.IAgriPlugin;
import com.infinityraider.agricraft.api.adapter.IAgriAdapterRegistry;
import com.infinityraider.agricraft.api.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.mutation.IAgriMutationEngine;
import com.infinityraider.agricraft.api.mutation.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.plant.IAgriPlantRegistry;
import com.infinityraider.agricraft.api.seed.AgriSeed;
import com.infinityraider.agricraft.api.soil.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.stat.IAgriStat;
import com.infinityraider.agricraft.api.stat.IAgriStatCalculatorRegistry;
import com.infinityraider.agricraft.apiimpl.FertilizerRegistry;
import com.infinityraider.agricraft.apiimpl.MutationEngine;
import com.infinityraider.agricraft.apiimpl.MutationRegistry;
import com.infinityraider.agricraft.apiimpl.PlantRegistry;
import com.infinityraider.agricraft.apiimpl.SeedRegistry;
import com.infinityraider.agricraft.apiimpl.SoilRegistry;
import com.infinityraider.agricraft.apiimpl.StatCalculatorRegistry;
import com.infinityraider.agricraft.apiimpl.StatRegistry;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public final class PluginHandler {
    private static final Deque<IAgriPlugin> plugins = new ConcurrentLinkedDeque<IAgriPlugin>();

    public static void preInit(FMLPreInitializationEvent event) {
        plugins.addAll(PluginHandler.getInstances(event.getAsmData(), AgriPlugin.class, IAgriPlugin.class));
    }

    public static void init() {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(IAgriPlugin::initPlugin);
    }

    public static void postInit() {
        PluginHandler.registerSoils(SoilRegistry.getInstance());
        PluginHandler.registerPlants(PlantRegistry.getInstance());
        PluginHandler.registerMutations(MutationRegistry.getInstance());
        PluginHandler.registerStats(StatRegistry.getInstance());
        PluginHandler.registerSeeds(SeedRegistry.getInstance());
        PluginHandler.registerFertilizers(FertilizerRegistry.getInstance());
        PluginHandler.registerStatCalculators(StatCalculatorRegistry.getInstance());
        PluginHandler.registerCrossStrategies(MutationEngine.getInstance());
    }

    public static void loadTextures(Consumer<ResourceLocation> registry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerTextures(registry));
    }

    public static void registerSoils(IAgriSoilRegistry soilRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerSoils(soilRegistry));
    }

    public static void registerPlants(IAgriPlantRegistry plantRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerPlants(plantRegistry));
    }

    public static void registerMutations(IAgriMutationRegistry mutationRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerMutations(mutationRegistry));
    }

    public static void registerStats(IAgriAdapterRegistry<IAgriStat> statRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerStats(statRegistry));
    }

    public static void registerSeeds(IAgriAdapterRegistry<AgriSeed> seedRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerSeeds(seedRegistry));
    }

    public static void registerFertilizers(IAgriAdapterRegistry<IAgriFertilizer> fertilizerRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerFertilizers(fertilizerRegistry));
    }

    public static void registerStatCalculators(IAgriStatCalculatorRegistry calculatorRegistry) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerStatCalculators(calculatorRegistry));
    }

    public static void registerCrossStrategies(IAgriMutationEngine mutationEngine) {
        plugins.stream().filter(IAgriPlugin::isEnabled).forEach(p -> p.registerCrossStrategies(mutationEngine));
    }

    private static <T> List<T> getInstances(ASMDataTable asm, Class anno, Class<T> type) {
        ArrayList<T> instances = new ArrayList<T>();
        for (ASMDataTable.ASMData asmData : asm.getAll(anno.getCanonicalName())) {
            try {
                T instance = Class.forName(asmData.getClassName()).asSubclass(type).newInstance();
                instances.add(instance);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError e) {
                AgriCore.getLogger("AgriCraft-Plugins").debug("%nFailed to load AgriPlugin%n\tOf class: {0}!%n\tFor annotation: {1}!%n\tAs Instanceof: {2}!", asmData.getClassName(), anno.getCanonicalName(), type.getCanonicalName());
            }
        }
        return instances;
    }
}

