/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.apiimpl;

import com.infinityraider.agricraft.api.mutation.IAgriCrossStrategy;
import com.infinityraider.agricraft.api.mutation.IAgriMutationEngine;
import com.infinityraider.agricraft.farming.mutation.MutateStrategy;
import com.infinityraider.agricraft.farming.mutation.SpreadStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.Tuple;

public final class MutationEngine
implements IAgriMutationEngine {
    private static final MutationEngine INSTANCE = new MutationEngine();
    private final List<Tuple<Double, IAgriCrossStrategy>> strategies = new ArrayList<Tuple<Double, IAgriCrossStrategy>>();
    private double sigma = 0.0;

    private MutationEngine() {
        this.registerStrategy(new MutateStrategy());
        this.registerStrategy(new SpreadStrategy());
    }

    public static MutationEngine getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean registerStrategy(IAgriCrossStrategy strategy) {
        if (strategy.getRollChance() >= 1.0 || strategy.getRollChance() <= 0.0) {
            throw new IndexOutOfBoundsException("Invalid roll chance!");
        }
        if (!this.hasStrategy(strategy)) {
            this.sigma += strategy.getRollChance();
            this.strategies.add((Tuple<Double, IAgriCrossStrategy>)new Tuple((Object)this.sigma, (Object)strategy));
            return true;
        }
        return false;
    }

    @Override
    public boolean hasStrategy(IAgriCrossStrategy strategy) {
        return this.strategies.stream().anyMatch(t -> ((IAgriCrossStrategy)t.func_76340_b()).equals(strategy));
    }

    @Override
    public List<IAgriCrossStrategy> getStrategies() {
        return this.strategies.stream().map(t -> (IAgriCrossStrategy)t.func_76340_b()).collect(Collectors.toList());
    }

    @Override
    public Optional<IAgriCrossStrategy> rollStrategy(Random rand) {
        double value = rand.nextDouble() * this.sigma;
        return this.strategies.stream().filter(t -> value <= (Double)t.func_76341_a()).map(t -> (IAgriCrossStrategy)t.func_76340_b()).findFirst();
    }
}

